/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram.props;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.table.fill.RectangleFillFactory;
import com.harrand.sketch.glyph.rect.fill.IRectangleFill;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public final class RectangleFillOptionPanel
extends JPanel {
    private RectangleFillFactory rectangleFillFactory = RectangleFillFactory.getInstance();
    private JComboBox cboFillOptions;
    private ComboBoxModel model;
    private IRectangleFill fill;

    public RectangleFillOptionPanel(IRectangleFill fill) {
        this.fill = fill;
        this.init();
    }

    public IRectangleFill getRectangleFill() {
        return (IRectangleFill)this.cboFillOptions.getSelectedItem();
    }

    public void loadOptMgrSettings() {
        IRectangleFill optionRectangleFill = this.rectangleFillFactory.getOptionMgrRectangleFill();
        if (optionRectangleFill != null) {
            this.model.setSelectedItem(optionRectangleFill);
        }
    }

    private void createComboBox() {
        ArrayList<IRectangleFill> fills = this.rectangleFillFactory.getRectangleFills();
        Vector<IRectangleFill> fillsVector = new Vector<IRectangleFill>(fills);
        this.model = new DefaultComboBoxModel<IRectangleFill>(fillsVector);
        this.cboFillOptions = new JComboBox(this.model);
        this.loadData();
    }

    private void loadData() {
        this.model.setSelectedItem(this.fill);
    }

    private void init() {
        this.setupGui();
    }

    private void setupGui() {
        this.createComponents();
        this.layoutComponents();
        this.setCosmetics();
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(GuiHelper.getLeftAlignedPanel(this.cboFillOptions));
        this.add(Box.createVerticalGlue());
    }

    private void setCosmetics() {
        GuiHelper.setTitledBorderBuffered(this, "Table Glyph Fill Type");
        this.cboFillOptions.setPrototypeDisplayValue("Information Engineering00000000");
    }

    private void createComponents() {
        this.createComboBox();
    }
}

