/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram.plugin.addfk;

import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.geometry.positioningCoord.IPositioningCoord;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.hilight.FkGlyphHilighter;
import com.harrand.dbwrench.diagram.hilight.color.GreenColorScheme;
import com.harrand.dbwrench.diagram.hilight.color.IColorScheme;
import com.harrand.dbwrench.diagram.table.DbTableGlyphLinkBoxesBldr;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.IJoint;
import com.harrand.sketch.core.IRawLineSource;
import com.harrand.sketch.interfaces.IHilightableGlyph;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.LinkAutoPositionInitializer;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.linkStrategies.rollover.ISingleLinkLinePossible;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.glyph.JointGlyph;
import com.harrand.sketch.relation.joint.JointDimensionCalc;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import com.harrand.sketch.relation.primitive.JointPrimitiveCalc;
import com.harrand.sketch.relation.rect.LinkRect;
import com.harrand.sketch.support.DrawableUtil;
import com.harrand.util.LogUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class PotentialFkGlyph
implements IDrawable,
BoxLink,
IEdgeTrackable,
IRawLineSource,
ISingleLinkLinePossible,
IHilightableGlyph {
    private final DbTableGlyph childTableGlyph;
    private DbTableGlyph parentTableGlyph;
    private JointGlyph parentJoint;
    private JointGlyph childJoint;
    private List enhancedShapes = new ArrayList();
    private ILinkPositioner linkPositioner;
    private final List<EnhancedShape> enhancedConnectors = new ArrayList<EnhancedShape>();
    private final List<EnhancedShape> unusedEnhancedConnectors = new ArrayList<EnhancedShape>();
    private List<? extends Shape> shapes = new ArrayList<Shape>();
    private final List<Line2D> rawLines = new ArrayList<Line2D>();
    private FkGlyphHilighter hilighter_;
    private Edge childEdge;
    private Edge parentEdge;
    private final DbTableGlyphLinkBoxesBldr dbTableGlyphLinkBoxesBldr = new DbTableGlyphLinkBoxesBldr();
    private boolean isSingleLinkLinePossible;
    private static final Color POTENTIAL_GLYPH_COLOR = Color.GREEN;
    private static final GreenColorScheme COLOR_SCHEME = GreenColorScheme.getInstance();

    public PotentialFkGlyph(DbTableGlyph parentTableGlyph, DbTableGlyph childTableGlyph) {
        this.childTableGlyph = childTableGlyph;
        this.setParentTableGlyph(parentTableGlyph);
        this.markParentTableGlyph();
        LogUtil.logMsg(this, "PotentialFKGLyph.created: " + parentTableGlyph.getName());
    }

    private void markParentTableGlyph() {
        this.parentTableGlyph.setSelected(true);
        this.parentTableGlyph.setColorScheme(COLOR_SCHEME);
    }

    public final void setParentTableGlyph(DbTableGlyph parentTableGlyph) {
        this.parentTableGlyph = parentTableGlyph;
        this.initJoints();
    }

    private Diagram getDiagram() {
        return this.parentTableGlyph.getDiagram();
    }

    public DbTableGlyph getParentTableGlyph() {
        return this.parentTableGlyph;
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        ArrayList<LinkBoxPair> linkBoxPairs = new ArrayList<LinkBoxPair>();
        linkBoxPairs.add(this.buildLinkBoxPair());
        new LinkAutoPositionInitializer().initializeLinkPositions(linkBoxPairs);
        this.linkPositioner.updateShapePositions(this);
        DrawableUtil.drawMixedItems(this.getShapes(), g2, zoom);
    }

    private LinkBoxPair buildLinkBoxPair() {
        LinkBoxPair linkBoxPair = new LinkBoxPair(this);
        this.dbTableGlyphLinkBoxesBldr.setDiagramBoxes(linkBoxPair, this.parentTableGlyph, this.childTableGlyph);
        return linkBoxPair;
    }

    private void initJoints() {
        Diagram diagram = this.getDiagram();
        JointDimensionCalc jntDimCalc = diagram.getJointDimensionCalc();
        JointPrimitiveCalc jntPrimitiveCalcPar = new JointPrimitiveCalc(new Point2D.Double(0.0, 0.0), 0.0, jntDimCalc);
        JointPrimitiveCalc jntPrimitiveCalcChd = new JointPrimitiveCalc(new Point2D.Double(0.0, 0.0), 0.0, jntDimCalc);
        LinkStrategy linkStrategy = diagram.getRenderConfig().getLinkStrategy();
        boolean isSelfJoin = this.getIsSelfJoin();
        Color strokeColor = POTENTIAL_GLYPH_COLOR;
        IErNotation erNotation = this.getErNotation();
        Cardinality parentCardinality = new Cardinality(false, true, false);
        this.parentJoint = new JointGlyph(erNotation, jntPrimitiveCalcPar, parentCardinality, strokeColor, this.getParentTableName(), this.getName(), linkStrategy, isSelfJoin);
        Cardinality childCardinality = new Cardinality(true, true, true);
        this.childJoint = new JointGlyph(erNotation, jntPrimitiveCalcChd, childCardinality, strokeColor, this.getChildTableName(), this.getName(), linkStrategy, isSelfJoin);
    }

    private IErNotation getErNotation() {
        return this.getDiagram().getDiagramProps().getErNotation();
    }

    private void buildEnhancedShapes() {
        this.updateEnhancedConnectors();
        this.enhancedShapes = new ArrayList<EnhancedShape>(this.enhancedConnectors);
        this.enhancedShapes.addAll(this.parentJoint.getEnhancedShapes());
        this.enhancedShapes.addAll(this.childJoint.getEnhancedShapes());
        this.enhancedShapes.addAll(this.getHilightDrawables(this.getDiagram()));
    }

    private void updateEnhancedConnectors() {
        this.enhancedConnectors.addAll(this.unusedEnhancedConnectors);
        int i = 0;
        for (Shape shape : this.shapes) {
            EnhancedShape enhancedLine;
            if (i < this.enhancedConnectors.size()) {
                enhancedLine = this.enhancedConnectors.get(i);
                enhancedLine.setShape(shape);
                enhancedLine.setStrokeColor(POTENTIAL_GLYPH_COLOR);
            } else {
                enhancedLine = new EnhancedShape(shape, POTENTIAL_GLYPH_COLOR);
                this.enhancedConnectors.add(enhancedLine);
            }
            enhancedLine.setIsDashed(this.getUseDashedLines());
            ++i;
        }
        this.unusedEnhancedConnectors.clear();
        for (int j = this.enhancedConnectors.size() - 1; j >= i; --j) {
            this.unusedEnhancedConnectors.add(this.enhancedConnectors.get(j));
            this.enhancedConnectors.remove(j);
        }
    }

    @Override
    public boolean getIsSelfJoin() {
        return this.getParTbl().getDotNote().equalsIgnoreCase(this.getChdTbl().getDotNote());
    }

    @Override
    public IJoint getJoint(String key) {
        switch (key) {
            case "ParentJoint": {
                return this.parentJoint;
            }
            case "ChildJoint": {
                return this.childJoint;
            }
        }
        return null;
    }

    @Override
    public void moveJoint(String key, Point2D p) {
        IJoint joint = this.getJoint(key);
        joint.move(new Point((int)p.getX(), (int)p.getY()));
    }

    @Override
    public void rotateJoint(String key, double angle) {
        IJoint joint = this.getJoint(key);
        joint.setAngle(angle);
    }

    @Override
    public LinkRect getBox(String key) {
        Rectangle2D box = key.equals("Child") ? this.childTableGlyph.getBounds2D() : this.parentTableGlyph.getBounds2D();
        return new LinkRect(box, key);
    }

    @Override
    public List<IDrawable> getHilightDrawables(Diagram diagram) {
        if (!this.isHilighterSet()) {
            this.hilighter_ = new FkGlyphHilighter(this);
            this.hilighter_.setColorScheme(COLOR_SCHEME);
        }
        List<IDrawable> hilightShapes = this.hilighter_.getHilightShapes(diagram);
        return hilightShapes;
    }

    @Override
    public void setShapes(List<? extends Shape> shapes) {
        this.shapes = shapes;
        LinkLineExtractor.extractLines(shapes, this.rawLines);
        this.buildEnhancedShapes();
    }

    @Override
    public List<? extends Shape> getShapes() {
        return this.enhancedShapes;
    }

    @Override
    public void setLinkPositioner(ILinkPositioner linkPositioner) {
        this.linkPositioner = linkPositioner;
    }

    @Override
    public void setNmPosCoord(IPositioningCoord nmPosCoord) {
    }

    private boolean isHilighterSet() {
        return this.hilighter_ != null;
    }

    @Override
    public String getChildBoxName() {
        return "Child";
    }

    @Override
    public String getParentBoxName() {
        return "Parent";
    }

    @Override
    public String getName() {
        return "fk" + this.getChildTableName() + this.getParentTableName();
    }

    public String getParentTableName() {
        return this.getParTbl().getName();
    }

    public String getChildTableName() {
        return this.getChdTbl().getName();
    }

    @Override
    public void setName(String newName) {
    }

    private Table getChdTbl() {
        return this.childTableGlyph.getTable();
    }

    private Table getParTbl() {
        return this.parentTableGlyph.getTable();
    }

    @Override
    public String getParentJointName() {
        return "ParentJoint";
    }

    @Override
    public String getChildJointName() {
        return "ChildJoint";
    }

    @Override
    public void setChildEdge(Edge edge) {
        this.childEdge = edge;
    }

    @Override
    public Edge getChildEdge() {
        return this.childEdge;
    }

    @Override
    public void setParentEdge(Edge edge) {
        this.parentEdge = edge;
    }

    @Override
    public Edge getParentEdge() {
        return this.parentEdge;
    }

    private boolean getUseDashedLines() {
        return false;
    }

    @Override
    public void setSingleLinkLinePossible(boolean isSingleLinkLinePossible) {
        this.isSingleLinkLinePossible = isSingleLinkLinePossible;
    }

    @Override
    public boolean getSingleLinkLinePossible() {
        return this.isSingleLinkLinePossible;
    }

    @Override
    public List<Line2D> getRawLines() {
        return new ArrayList<Line2D>(this.rawLines);
    }

    void clear() {
        if (this.parentTableGlyph != null) {
            this.parentTableGlyph.setSelected(false);
            this.parentTableGlyph.setDefaultHilightSchema();
        }
    }

    @Override
    public void setColorScheme(IColorScheme colorScheme) {
        this.hilighter_.setColorScheme(colorScheme);
    }
}

