/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram.plugin.addfk;

import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.command.AddFkFromPk;
import com.harrand.dbwrenchgui.diagram.plugin.addfk.PotentialFkGlyph;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.interfaces.IDiagramPlugin;
import com.harrand.sketch.j2d.DiagramPanel;
import com.harrand.sketch.j2d.draw.IDrawable;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;

public class AddFkByDiagramPlugin
implements IDiagramPlugin {
    private final DbTableGlyph childGlyph;
    private final DiagramPanel diagramPanel;
    private PotentialFkGlyph potentialFkGlyph;

    public AddFkByDiagramPlugin(DiagramPanel diagramPanel, DbTableGlyph childGlyph) {
        this.childGlyph = childGlyph;
        this.diagramPanel = diagramPanel;
    }

    @Override
    public Collection<IDrawable> getDrawables() {
        ArrayList<IDrawable> drawables = new ArrayList<IDrawable>();
        if (this.isPotentialFkGlyphSet()) {
            drawables.add(this.potentialFkGlyph);
        }
        return drawables;
    }

    @Override
    public void processOverGlyph(Glyph overGlyph) {
        if (overGlyph instanceof DbTableGlyph) {
            DbTableGlyph parentGlyph = (DbTableGlyph)overGlyph;
            if (!parentGlyph.equals(this.childGlyph)) {
                this.updatePotentialFkGlyph(parentGlyph);
            }
        } else {
            this.clear();
        }
    }

    private void clear() {
        if (this.isPotentialFkGlyphSet()) {
            this.potentialFkGlyph.clear();
        }
        this.potentialFkGlyph = null;
    }

    private boolean isPotentialFkGlyphSet() {
        return this.potentialFkGlyph != null;
    }

    private void updatePotentialFkGlyph(DbTableGlyph parentGlyph) {
        if (this.isPotentialFkGlyphSet()) {
            this.potentialFkGlyph.setParentTableGlyph(parentGlyph);
        } else {
            this.potentialFkGlyph = new PotentialFkGlyph(parentGlyph, this.childGlyph);
        }
    }

    @Override
    public void processKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.exitPlugin();
        }
    }

    @Override
    public void processMouseDown() {
        if (this.isPotentialFkGlyphSet()) {
            Table childTable = this.childGlyph.getTable();
            Table parentTable = this.potentialFkGlyph.getParentTableGlyph().getTable();
            AddFkFromPk cmd = new AddFkFromPk(childTable.getSchema().getDb(), childTable, parentTable, CommandChainMgr.getCmdChain());
            cmd.actionPerformed(null);
            this.exitPlugin();
        }
    }

    private void exitPlugin() {
        this.clear();
        this.diagramPanel.setPlugin(null);
    }
}

