/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.display.IColorable;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.glyph.RectGlyph;
import com.harrand.sketch.glyph.interfaces.IGlyphLocator;
import com.harrand.sketch.interfaces.IGradientable;
import com.harrand.sketch.interfaces.INavigator;
import com.harrand.sketch.interfaces.INavigatorSrc;
import com.harrand.sketch.j2d.DiagramExporter;
import com.harrand.util.LogUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NavigatorPanel
extends JPanel
implements INavigator,
ITitled,
ISized,
IObservable,
IObserver,
MouseListener,
MouseMotionListener,
IRefreshable {
    private Diagram diagram_;
    private BufferedImage dBuffImg_;
    private BufferedImage zoomedImage_;
    private BasicObservable observable_ = new BasicObservable();
    private Rectangle2D portal_ = null;
    private INavigatorSrc navigatorSrc_;
    private IGlyphLocator glyphLocator;
    private Dimension drawSz_ = new Dimension(0, 0);
    private Dimension drawSzZm_ = new Dimension(0, 0);
    private Dimension maxSize_ = new Dimension();
    private Point2D origin_ = new Point2D.Double(0.0, 0.0);
    private JLabel lblMouseOver_ = null;
    private double zoomLevel_ = 1.0;
    private Point dragStart_;
    private Point preDragPortalOrigin_;
    private Color lightBlue_ = new Color(237, 237, 255, 150);
    public static final int EDGE_MARGIN = 100;
    private static final int DEF_IMG_SIDE = 150;

    public NavigatorPanel() {
        this.setupGui();
        this.zoomedImage_ = GuiHelper.getBufferedImage(150, 150, true);
        this.dBuffImg_ = GuiHelper.getBufferedImage(150, 150, true);
        this.setPortalInDiaCoords(new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setMaxSize(Dimension d) {
        this.maxSize_ = d;
        this.setSize(this.maxSize_);
    }

    @Override
    public void setDiagram(Diagram diagram) {
        this.diagram_ = diagram;
        this.diagram_.setNvPanel(this);
        this.refresh();
        this.repaint();
    }

    @Override
    public void setPortalInDiaCoords(Rectangle2D vpRect) {
        double diaZmLevel = this.diagram_ != null ? this.diagram_.getZoom().getLevel() : 1.0;
        Rectangle2D diagramViewableRect = Zoomer.zoom(vpRect, 1.0 / diaZmLevel);
        Rectangle2D untranslatedPortal = Zoomer.zoom(diagramViewableRect, this.zoomLevel_);
        this.portal_ = new Rectangle2D.Double(untranslatedPortal.getX() + this.origin_.getX(), untranslatedPortal.getY() + this.origin_.getY(), untranslatedPortal.getWidth(), untranslatedPortal.getHeight());
        this.repaint();
    }

    @Override
    public void setNavigatorSrc(INavigatorSrc navigatorSrc) {
        this.navigatorSrc_ = navigatorSrc;
        if (this.navigatorSrc_ instanceof IGlyphLocator) {
            this.glyphLocator = (IGlyphLocator)((Object)this.navigatorSrc_);
        }
        this.refresh();
    }

    public void setMouseOverLabel(JLabel lblMouseOver) {
        this.lblMouseOver_ = lblMouseOver;
    }

    public double getZoomLevel() {
        return this.zoomLevel_;
    }

    @Override
    public Rectangle2D getPortalInDiaCoords() {
        double diaZmLevel = this.diagram_ != null ? this.diagram_.getZoom().getLevel() : 1.0;
        Rectangle2D.Double translatedPortal = new Rectangle2D.Double(this.portal_.getX() - this.origin_.getX(), this.portal_.getY() - this.origin_.getY(), this.portal_.getWidth(), this.portal_.getHeight());
        Rectangle2D diagramViewableRect = Zoomer.zoom(translatedPortal, diaZmLevel);
        Rectangle2D portalInDiaCoords = Zoomer.zoom(diagramViewableRect, 1.0 / this.zoomLevel_);
        return portalInDiaCoords;
    }

    public Point2D getOrigin() {
        return new Point2D.Double(this.origin_.getX(), this.origin_.getY());
    }

    public void calcZoomLevel(Dimension panelSize) {
        Rectangle2D bounds = this.isDiagramSet() ? this.diagram_.getBounds2D() : new Rectangle2D.Double(0.0, 0.0, 150.0, 150.0);
        this.drawSz_ = new Dimension((int)bounds.getWidth() + 100, (int)bounds.getHeight() + 100);
        double drawHeight = this.drawSz_.getHeight();
        double drawWidth = this.drawSz_.getWidth();
        double heightRatio = panelSize.getHeight() / drawHeight;
        double widthRatio = panelSize.getWidth() / drawWidth;
        this.zoomLevel_ = Math.min(heightRatio, widthRatio);
        if (this.zoomLevel_ >= 1.0 || this.zoomLevel_ == 0.0) {
            this.zoomLevel_ = 1.0;
        }
        this.drawSzZm_ = Zoomer.zoom(this.drawSz_, this.zoomLevel_);
    }

    @Override
    public void clearObserversOfClass(String classNm) {
        ArrayList<IObserver> obsRemove = new ArrayList<IObserver>();
        for (IObserver observer : this.observable_.getObservers()) {
            String obsClassNm = observer.getClass().getName();
            if (!obsClassNm.equals(classNm)) continue;
            obsRemove.add(observer);
        }
        for (IObserver observer : obsRemove) {
            this.removeObserver(observer);
        }
    }

    private boolean isDbTableGlyph(Glyph glyph) {
        return glyph != null && glyph instanceof DbTableGlyph;
    }

    private boolean isDiagramSet() {
        return this.diagram_ != null;
    }

    private boolean isDiagramValid() {
        if (!this.isDiagramSet()) {
            return false;
        }
        return this.diagram_.getOnlyGlyphs().size() != 0;
    }

    @Override
    public void refresh() {
        this.calcZoomLevel(new Dimension(this.maxSize_));
        this.updateOrigin();
        if (this.navigatorSrc_ != null) {
            this.setPortalInDiaCoords(this.navigatorSrc_.getPortal());
        }
        this.updateZoomedImage();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.renderImage();
        g.drawImage(this.dBuffImg_, 0, 0, null);
        Toolkit.getDefaultToolkit().sync();
    }

    private boolean isNvSrcSet() {
        return this.navigatorSrc_ != null;
    }

    @Deprecated
    private void paintScreen() {
        try {
            Graphics g = this.getGraphics();
            GuiHelper.setAntiAliasOn((Graphics2D)g);
            this.renderImage();
            g.drawImage(this.dBuffImg_, 0, 0, null);
            Toolkit.getDefaultToolkit().sync();
            g.dispose();
        }
        catch (Exception e) {
            LogUtil.logErr("NavigatorPanel.paintScreen.err: " + e.getMessage());
        }
    }

    private void renderImage() {
        Graphics2D gfxBuff = (Graphics2D)this.dBuffImg_.getGraphics();
        GuiHelper.setAntiAliasOn(gfxBuff);
        Rectangle2D.Double buffImgSz = new Rectangle2D.Double(0.0, 0.0, this.dBuffImg_.getWidth() - 1, this.dBuffImg_.getHeight() - 1);
        DiagramExporter.setBackColor(gfxBuff, this.getBackground(), buffImgSz);
        gfxBuff.drawImage((Image)this.zoomedImage_, (int)this.origin_.getX(), (int)this.origin_.getY(), null);
        if (this.isNvSrcSet()) {
            this.drawPortal(gfxBuff);
        }
    }

    private void updateOrigin() {
        double thisHeight = this.maxSize_.getHeight();
        double thisWidth = this.maxSize_.getWidth();
        double vertExcess = thisHeight - this.drawSzZm_.getHeight();
        double horzExcess = thisWidth - this.drawSzZm_.getWidth();
        this.origin_ = horzExcess > vertExcess ? new Point2D.Double(horzExcess / 2.0, 0.0) : new Point2D.Double(0.0, vertExcess / 2.0);
    }

    private void updateZoomedImage() {
        this.calcZoomLevel(this.maxSize_);
        this.checkCanvasSize();
        Graphics2D gfxZoomed = (Graphics2D)this.zoomedImage_.getGraphics();
        GuiHelper.setAntiAliasOn(gfxZoomed);
        Rectangle2D.Double canvasSize = new Rectangle2D.Double(0.0, 0.0, this.zoomedImage_.getWidth(), this.zoomedImage_.getHeight());
        DiagramExporter.setBackColor(gfxZoomed, this.getBackground(), canvasSize);
        Rectangle2D.Double slideLimit = new Rectangle2D.Double(0.0, 0.0, this.drawSzZm_.getWidth(), this.drawSzZm_.getHeight());
        DiagramExporter.setBackColor(gfxZoomed, Color.WHITE, slideLimit);
        if (this.diagram_ != null && this.isNvSrcSet()) {
            this.drawGlyphs(gfxZoomed);
            this.drawFks(gfxZoomed);
        } else {
            this.drawNoDiagramText(gfxZoomed);
        }
    }

    private void checkCanvasSize() {
        boolean isMaxSizeSet;
        boolean panelIsShowing = this.getSize().getWidth() > 0.0;
        boolean bl = isMaxSizeSet = this.maxSize_.width > 0 && this.maxSize_.height > 0;
        if (panelIsShowing && isMaxSizeSet) {
            boolean needBigger;
            int drawSzZmWidth = (int)this.drawSzZm_.getWidth();
            int drawSzZmHeight = (int)this.drawSzZm_.getHeight();
            boolean widthOversized = this.zoomedImage_.getWidth() < drawSzZmWidth;
            boolean heightOversized = this.zoomedImage_.getHeight() < drawSzZmHeight;
            boolean bl2 = needBigger = widthOversized || heightOversized;
            if (needBigger) {
                this.zoomedImage_ = GuiHelper.getBufferedImage(drawSzZmWidth, drawSzZmHeight, false);
                this.dBuffImg_ = GuiHelper.getBufferedImage(this.maxSize_.width, this.maxSize_.height, false);
            }
        }
    }

    private void drawGlyphAsRect(Graphics2D gfx, Glyph glyph) {
        Color color = Color.GRAY;
        boolean useGradient = false;
        if (glyph instanceof IColorable) {
            color = ((IColorable)((Object)glyph)).getColor("MainBox");
        }
        if (glyph instanceof IGradientable) {
            useGradient = ((IGradientable)((Object)glyph)).getUseGradient();
        }
        Rectangle2D rect = Zoomer.zoom(glyph.getBounds2D(), this.zoomLevel_);
        RectGlyph rectGlyph = new RectGlyph(rect);
        rectGlyph.setBgColor(color);
        rectGlyph.setUseGradient(useGradient);
        rectGlyph.draw(gfx);
    }

    private void drawGlyphs(Graphics2D gfx) {
        Zoom zoom = new Zoom(this.zoomLevel_);
        List<Glyph> glyphs = this.diagram_.getGlyphsInRenderOrder(true);
        for (Glyph glyph : glyphs) {
            if (glyph instanceof ForeignKeyGlyph) {
                this.drawFK((ForeignKeyGlyph)glyph, gfx, zoom);
                continue;
            }
            this.drawGlyphAsRect(gfx, glyph);
        }
    }

    private void drawFks(Graphics2D gfx) {
        Zoom zoom = new Zoom(this.zoomLevel_);
        Iterator itLinks = this.diagram_.getLinksList().iterator();
        while (itLinks.hasNext()) {
            this.drawFK((ForeignKeyGlyph)itLinks.next(), gfx, zoom);
        }
    }

    public void drawFK(ForeignKeyGlyph fkGlyph, Graphics2D gfx, Zoom zoom) {
        fkGlyph.draw(gfx, zoom);
    }

    private void drawPortal(Graphics2D gfx) {
        Paint oldPaint = gfx.getPaint();
        gfx.setPaint(this.lightBlue_);
        gfx.fill(this.portal_);
        gfx.setPaint(Colors.getGreenMilitary());
        gfx.draw(this.portal_);
        gfx.setPaint(oldPaint);
    }

    private void showTableNm(Point mousePt) {
        String tblNm = "";
        Glyph glyph = this.getGlyphUnderMouse(mousePt);
        if (this.isDbTableGlyph(glyph)) {
            DbTableGlyph tblGlyph = (DbTableGlyph)glyph;
            Table tbl = tblGlyph.getTable();
            tblNm = tbl.getForEngNm(tbl.getName(), true, false, null);
        }
        if (this.lblMouseOver_ != null) {
            this.lblMouseOver_.setText(tblNm);
        }
    }

    private void checkLocateGlyph(Point dragStart_) {
        Glyph glyph = this.getGlyphUnderMouse(dragStart_);
        if (this.glyphLocator != null && this.isDbTableGlyph(glyph)) {
            this.glyphLocator.locateGlyph(glyph.getName());
        }
    }

    private void checkCursor(MouseEvent mouseEvt) {
        Point mousePt = mouseEvt.getPoint();
        if (this.isOverPortal(mousePt)) {
            boolean isBtnDown = GuiHelper.isMouseBtn1Down(mouseEvt);
            GuiHelper.setClosedHandCursor(this);
            if (!isBtnDown) {
                GuiHelper.setOpenHandCursor(this);
            }
            return;
        }
        Glyph glyph = this.getGlyphUnderMouse(mousePt);
        if (this.isDbTableGlyph(glyph)) {
            GuiHelper.setFingerCursor(this);
            return;
        }
        GuiHelper.setDefaultCursor(this);
    }

    private boolean isOverPortal(Point mousePt) {
        Point2D.Double pt2D = new Point2D.Double(mousePt.getX(), mousePt.getY());
        return this.portal_.contains(pt2D);
    }

    private Glyph getGlyphUnderMouse(Point ptRaw) {
        Glyph glyph = null;
        if (this.isNvSrcSet()) {
            String tblNm = "";
            if (this.diagram_ != null) {
                double diaZmLevel = this.diagram_.getZoom().getLevel();
                double compositeZm = 1.0 / diaZmLevel * this.zoomLevel_;
                Point ptZm = new Point((int)ptRaw.getX() - (int)this.origin_.getX(), (int)ptRaw.getY() - (int)this.origin_.getY());
                Point ptDiagram = Zoomer.zoom(ptZm, 1.0 / compositeZm);
                glyph = this.diagram_.getGlyphContainingPoint(ptDiagram);
            }
        }
        return glyph;
    }

    private void drawNoDiagramText(Graphics2D g2) {
        String msg = "<No Diagram Selected>";
        Font font = new Font("Dialog", 0, 10);
        Dimension rect = new Dimension((int)this.drawSzZm_.getWidth(), (int)this.drawSzZm_.getHeight());
        Dimension start = GuiHelper.getCenteredTextOrigin(rect, font, msg);
        Paint oldPaint = g2.getPaint();
        g2.setPaint(Color.BLACK);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(font);
        g2.drawString(msg, start.width, start.height);
        g2.setPaint(oldPaint);
    }

    private void setupGui() {
        this.layoutComponents();
    }

    private void layoutComponents() {
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.NAVIGATOR;
    }

    @Override
    public String getTitle() {
        return "Navigator";
    }

    @Override
    public String getToolTip() {
        return "Navigator";
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 210, 180);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.checkCursor(mouseEvent);
        if (this.dragStart_ != null && this.isDiagramValid()) {
            Point currentPt = mouseEvent.getPoint();
            double dragX = currentPt.getX() - this.dragStart_.getX();
            double dragY = currentPt.getY() - this.dragStart_.getY();
            double maxOriginX = this.origin_.getX() + this.drawSzZm_.getWidth() - this.portal_.getWidth();
            double minOriginX = this.origin_.getX();
            double newOriginX = this.preDragPortalOrigin_.getX() + dragX;
            if (newOriginX > maxOriginX) {
                newOriginX = maxOriginX;
            }
            if (newOriginX < minOriginX) {
                newOriginX = minOriginX;
            }
            double maxOriginY = this.origin_.getY() + this.drawSzZm_.getHeight() - this.portal_.getHeight();
            double minOriginY = this.origin_.getY();
            double newOriginY = this.preDragPortalOrigin_.getY() + dragY;
            if (newOriginY > maxOriginY) {
                newOriginY = maxOriginY;
            }
            if (newOriginY < minOriginY) {
                newOriginY = minOriginY;
            }
            this.portal_ = new Rectangle2D.Double(newOriginX, newOriginY, this.portal_.getWidth(), this.portal_.getHeight());
            this.paintScreen();
            this.repaint();
            this.notifyObservers(null);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.checkCursor(mouseEvent);
        this.showTableNm(mouseEvent.getPoint());
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.lblMouseOver_ != null) {
            this.lblMouseOver_.setText("");
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dragStart_ = mouseEvent.getPoint();
        if (this.isOverPortal(this.dragStart_)) {
            this.preDragPortalOrigin_ = new Point((int)this.portal_.getX(), (int)this.portal_.getY());
        } else {
            this.checkLocateGlyph(this.dragStart_);
            this.dragStart_ = null;
            this.preDragPortalOrigin_ = null;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragStart_ = null;
        this.checkCursor(mouseEvent);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }

    @Override
    public INavigatorSrc getNavigatorSrc() {
        return this.navigatorSrc_;
    }
}

