/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.display.ISpaceConservable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.dnd.IDragSource;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.dbwrench.diagram.autoLayout.DbLayoutCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.command.DwrDeleteGlyphsCmdFactory;
import com.harrand.dbwrenchgui.diagram.DiagramCmdBldr;
import com.harrand.dbwrenchgui.diagram.DiagramEditPanel;
import com.harrand.dbwrenchgui.diagram.NvFullPanel;
import com.harrand.dbwrenchgui.panel.ColumnEditPanel;
import com.harrand.dbwrenchgui.panel.ForeignKeyPanel;
import com.harrand.dbwrenchgui.panel.TableDetailsPanel;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.j2d.DiagramTabPanel;
import com.harrand.sketch.zoom.IZoomablePanel;
import com.harrand.sketch.zoom.ZoomToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

@Deprecated
public final class DiagramPropertyPanel
extends JPanel
implements IObserver,
IZoomablePanel,
ComponentListener {
    private Database db_;
    private DiagramTabPanel diagramTabPanel_;
    private NvFullPanel nvFullPanel_ = new NvFullPanel();
    private DbUser user_;
    private JPanel propertyPanel_;
    private JPanel northPanel_;
    private JPanel southWestPanel_;
    private JPanel blankPanel_;
    private IOptionMgr splitPosOptMgr_;
    private JSplitPane spHorz_;
    private JSplitPane spVert_;
    private HeaderPanel header_ = new HeaderPanel("");
    private PropertyChangeListener lisHorz_;
    private PropertyChangeListener lisVert_;
    private boolean splitPositionsInited_ = false;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
    private static final int PROPERTY_PANEL_HEIGHT_DEFAULT = 230;
    private static final int NV_WIDTH_DEFAULT = 150;

    @Deprecated
    public DiagramPropertyPanel(Database db) {
        this.db_ = db;
        this.diagramTabPanel_ = new DiagramTabPanel(this.db_);
        this.diagramTabPanel_.addObserver(this);
        this.diagramTabPanel_.setCommandChain(App.getCommandChain());
        this.diagramTabPanel_.setDiagramCmdBldr(new DiagramCmdBldr(null));
        this.diagramTabPanel_.setNavigator(this.nvFullPanel_.getNvPanel());
        this.diagramTabPanel_.setDeleteGlyphsCmdFactory(new DwrDeleteGlyphsCmdFactory());
        if (this.db_ != null) {
            this.db_.addObserver(this);
        }
        DbLayoutCtrl layoutCtrl = new DbLayoutCtrl(this.db_);
        this.diagramTabPanel_.setLayoutCtrl(layoutCtrl);
        this.user_ = App.getUser();
        this.splitPosOptMgr_ = this.user_.getOptionMgr("splitter.pos.opt.mgr");
        this.initComponents();
        this.buildPanel();
        this.addListeners();
        this.setCosmetics();
    }

    public void setDb(Database db) {
        this.db_ = db;
        this.diagramTabPanel_.setDiagramSrv(this.db_);
        this.diagramTabPanel_.setLayoutCtrl(new DbLayoutCtrl(this.db_));
        this.propertyPanel_ = null;
        this.southWestPanel_.removeAll();
        this.southWestPanel_.add((Component)this.blankPanel_, "Center");
        this.southWestPanel_.invalidate();
        this.southWestPanel_.revalidate();
        this.southWestPanel_.repaint();
        if (this.db_ != null) {
            this.db_.addObserver(this);
        }
    }

    public void setBusyCursor() {
        this.diagramTabPanel_.setBusyCursor();
    }

    public void setDefaultCursor() {
        this.diagramTabPanel_.setDefaultCursor();
    }

    private void buildPanel() {
        this.southWestPanel_ = new JPanel(new BorderLayout());
        this.addPanels();
        this.setNames();
    }

    private void addPanels() {
        this.initSpVert();
        this.northPanel_ = new JPanel(new BorderLayout());
        this.northPanel_.add((Component)this.diagramTabPanel_, "Center");
        this.spHorz_ = new JSplitPane(0);
        this.spHorz_.setDividerSize(5);
        this.blankPanel_ = new JPanel();
        this.southWestPanel_.add((Component)this.blankPanel_, "Center");
        this.themeCtrl_.process(this.blankPanel_);
        this.themeCtrl_.process(this.northPanel_);
        this.themeCtrl_.process(this.spHorz_);
        this.setLayout(new BorderLayout());
        this.spHorz_.setTopComponent(this.northPanel_);
        this.spHorz_.setBottomComponent(this.spVert_);
        this.spHorz_.setResizeWeight(1.0);
        this.add(this.spHorz_);
        this.positionDividers();
        this.refreshNvPanel();
    }

    private void initSpVert() {
        this.spVert_ = new JSplitPane(1);
        this.spVert_.setDividerSize(5);
        this.spVert_.setTopComponent(this.southWestPanel_);
        this.spVert_.setBottomComponent(this.nvFullPanel_);
        this.spVert_.setResizeWeight(1.0);
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.southWestPanel_);
    }

    public void locateGlyph(String glyphNm) {
        this.diagramTabPanel_.locateGlyph(glyphNm);
    }

    public void setDragSource(IDragSource source) {
        this.diagramTabPanel_.setDragSource(source);
    }

    private void checkDividerSetLocation() {
        if (this.splitPosOptMgr_ != null) {
            int spNvPos = this.spVert_.getDividerLocation();
            int spPropPos = this.spHorz_.getDividerLocation();
            this.splitPosOptMgr_.setIntValue("split.pos.db.exp.nv", spNvPos);
            this.splitPosOptMgr_.setIntValue("split.pos.db.exp.prop", spPropPos);
        }
        this.refreshNvPanel();
    }

    private void addListeners() {
        this.lisHorz_ = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("lastDividerLocation")) {
                    DiagramPropertyPanel.this.checkDividerSetLocation();
                }
            }
        };
        this.spHorz_.addPropertyChangeListener(this.lisHorz_);
        this.lisVert_ = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("lastDividerLocation")) {
                    DiagramPropertyPanel.this.checkDividerSetLocation();
                }
            }
        };
        this.spVert_.addPropertyChangeListener(this.lisVert_);
        this.addComponentListener(this);
    }

    public void setDiagram(Diagram diagram) {
        this.diagramTabPanel_.setDiagram(diagram);
    }

    public Diagram getDiagram() {
        return this.diagramTabPanel_.getDiagram();
    }

    public void setPropertyMainPanel(JPanel mainPanel) {
        if (mainPanel instanceof DiagramEditPanel || mainPanel instanceof ColumnEditPanel) {
            mainPanel = this.blankPanel_;
        }
        if (mainPanel instanceof TableDetailsPanel && this.propertyPanel_ instanceof TableDetailsPanel) {
            TableDetailsPanel oldTableDetailsPanel = (TableDetailsPanel)this.propertyPanel_;
            TableDetailsPanel newTableDetailsPanel = (TableDetailsPanel)mainPanel;
            Table newTable = newTableDetailsPanel.getTable();
            oldTableDetailsPanel.setTable(newTable);
        } else if (mainPanel instanceof ForeignKeyPanel && this.propertyPanel_ instanceof ForeignKeyPanel) {
            ForeignKeyPanel oldFkPanel = (ForeignKeyPanel)this.propertyPanel_;
            ForeignKeyPanel newFkPanel = (ForeignKeyPanel)mainPanel;
            ForeignKey newFk = newFkPanel.getForeignKey();
            oldFkPanel.setForeignKey(newFk);
            this.reloadSouthWestPanel();
        } else {
            this.propertyPanel_ = mainPanel;
            this.themeCtrl_.process(this.propertyPanel_);
            this.reloadSouthWestPanel();
        }
        this.propertyPanel_.invalidate();
        this.propertyPanel_.revalidate();
        this.propertyPanel_.repaint();
        this.southWestPanel_.invalidate();
        this.southWestPanel_.revalidate();
        this.southWestPanel_.repaint();
    }

    private void reloadSouthWestPanel() {
        this.southWestPanel_.removeAll();
        this.southWestPanel_.add((Component)this.propertyPanel_, "Center");
        if (this.propertyPanel_ instanceof DataEditor) {
            DataEditor dataEditor = (DataEditor)((Object)this.propertyPanel_);
            dataEditor.setSyncOnEdit(true);
            this.header_.setTitle(dataEditor.getTitle());
            this.southWestPanel_.add((Component)this.header_, "North");
        }
        if (this.propertyPanel_ instanceof ISpaceConservable) {
            ((ISpaceConservable)((Object)this.propertyPanel_)).setConserveSpace(true);
        }
        GuiHelper.addSmallBorder(this.southWestPanel_);
    }

    private void positionDividers() {
        int horzPos = this.splitPosOptMgr_.getIntValue("split.pos.db.exp.prop");
        int vertPos = this.splitPosOptMgr_.getIntValue("split.pos.db.exp.nv");
        this.spHorz_.setDividerLocation(horzPos);
        this.spVert_.setDividerLocation(vertPos);
        this.refreshNvPanel();
    }

    private void refreshPropPanel() {
        if (this.propertyPanel_ instanceof IRefreshable) {
            ((IRefreshable)((Object)this.propertyPanel_)).refresh();
        }
    }

    private void refreshNvPanel() {
        int propHt = this.getHeight() - this.spHorz_.getDividerLocation();
        int nvWidth = this.getWidth() - this.spVert_.getDividerLocation();
        this.nvFullPanel_.refreshNvPanel(nvWidth, propHt);
    }

    private void setNames() {
        this.diagramTabPanel_.setName("diagramTabPanel");
        this.spHorz_.setName("sp");
        this.setName("DiagramPropertyPanel");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(Glyph.class.getName()) && chain.hasClassName(Point.class.getName())) {
            this.setPropertyMainPanel(this.diagramTabPanel_.getPropertyPanel());
        }
        if (chain.hasInteface(Identifiable.class.getName())) {
            this.refreshPropPanel();
        }
        this.checkObjectRemoved();
    }

    private void checkObjectRemoved() {
        if (this.propertyPanel_ instanceof TableDetailsPanel) {
            TableDetailsPanel detailsPanel = (TableDetailsPanel)this.propertyPanel_;
            Table tbl = detailsPanel.getTable();
            Schema schema = tbl.getSchema();
            if (tbl.getSchema() == null) {
                this.setBlankPanel();
            } else if (!schema.containsTable(tbl.getName())) {
                this.setBlankPanel();
            }
        } else if (this.propertyPanel_ instanceof ForeignKeyPanel) {
            ForeignKeyPanel fkPanel = (ForeignKeyPanel)this.propertyPanel_;
            ForeignKey fk = fkPanel.getForeignKeyAsIs();
            Table chdTbl = fk.getChdTbl();
            if (fk == null || chdTbl == null) {
                this.setBlankPanel();
            } else if (!chdTbl.contains(fk.getClassName(), fk.getName())) {
                this.setBlankPanel();
            }
        } else if (this.propertyPanel_ instanceof DataEditor) {
            DataEditor dataEditor = (DataEditor)((Object)this.propertyPanel_);
            dataEditor.setSyncOnEdit(false);
            Collector coll = dataEditor.getCollector();
            Identifiable idf = dataEditor.getDataObject();
            if (coll == null || idf == null) {
                this.setBlankPanel();
            } else {
                String idfNm = idf.getName();
                Set keys = coll.getKeys(idf.getMapName());
                if (!keys.contains(idfNm)) {
                    this.setBlankPanel();
                }
            }
            dataEditor.setSyncOnEdit(true);
        }
    }

    private void setBlankPanel() {
        this.setPropertyMainPanel(this.blankPanel_);
    }

    @Override
    public void setZoomToolbar(ZoomToolbar zoomToolbar) {
        this.diagramTabPanel_.setZoomToolbar(zoomToolbar);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (!this.splitPositionsInited_) {
            this.positionDividers();
        }
        this.splitPositionsInited_ = true;
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

