/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.diagram.DisplayColumnsPanel;
import com.harrand.dbwrenchgui.diagram.layout.RightAngleLinksRefreshChecker;
import com.harrand.dbwrenchgui.diagram.props.ClickActionsEditPanel;
import com.harrand.dbwrenchgui.diagram.props.LinkStrategyPanel;
import com.harrand.dbwrenchgui.diagram.props.RectangleFillOptionPanel;
import com.harrand.dbwrenchgui.diagram.props.ShowFkNmsEditPanel;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.glyph.rect.fill.IRectangleFill;
import com.harrand.sketch.j2d.VerbosityPanel;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import com.harrand.sketch.relation.panel.ErNotationSelectPanel;
import com.harrand.sketch.xml.DiagramProps;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class DiagramEditPanel
extends JPanel
implements DataEditor,
ITitled {
    private static DiagramEditPanel instance__ = new DiagramEditPanel();
    private Database db_;
    private Diagram diagram_ = null;
    private JTabbedPane tabs_ = new JTabbedPane();
    private VerbosityPanel vbPanel_;
    private DisplayColumnsPanel displayColsPanel_;
    private LinkStrategyPanel linkStrategyPanel;
    private ShowFkNmsEditPanel fkNmsPanel;
    private ErNotationSelectPanel erNotationPanel;
    private RectangleFillOptionPanel rectangleFillPanel;
    private ClickActionsEditPanel clickActionsEditPanel;
    private JTextField txtName_ = new JTextField();
    private JComboBox cboFontSize_;
    private JLabel lblName_;
    private JLabel lblFontSize_;
    private boolean syncOnEdit_ = false;
    private IOptionMgr optionMgr_ = null;
    private SwingThemeCtrl themeCtrl_;
    private boolean panelIsInitalized;

    private DiagramEditPanel() {
    }

    public static DiagramEditPanel getInstance() {
        return instance__;
    }

    public JPanel getFontPanel() {
        JPanel fontPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        fontPanel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPairFixed(this.lblFontSize_, this.cboFontSize_, gbc, fontPanel, row++);
        fontPanel.setBorder(BorderFactory.createTitledBorder("Font"));
        return fontPanel;
    }

    public int getStrutHeight() {
        return 16;
    }

    public void setItems(Diagram diagram, Database db) {
        this.db_ = db;
        this.diagram_ = diagram;
        if (!this.panelIsInitalized) {
            this.initPanel();
        }
        this.refresh();
    }

    private RenderConfig getRenderConfig() {
        return this.diagram_.getRenderConfig();
    }

    private void initPanel() {
        this.buildControls();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.optionMgr_ = App.getUser().getOptionMgr("diagram.option.mgr");
        this.setupGui();
        this.loadData();
        this.buildListeners();
        this.panelIsInitalized = true;
    }

    public void refresh() {
        this.loadData();
    }

    public void setOptionMgr(IOptionMgr optionMgr) {
        this.optionMgr_ = optionMgr;
        this.loadData();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
    }

    private void buildListeners() {
    }

    private boolean isDiagramSet() {
        return this.diagram_ != null;
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel("Name" + div);
        this.lblFontSize_ = new JLabel("Font Size" + div);
        Vector<String> vSizes = new Vector<String>();
        vSizes.add("6");
        vSizes.add("7");
        vSizes.add("8");
        vSizes.add("9");
        vSizes.add("10");
        vSizes.add("11");
        vSizes.add("12");
        vSizes.add("13");
        vSizes.add("14");
        vSizes.add("16");
        vSizes.add("18");
        vSizes.add("20");
        vSizes.add("24");
        vSizes.add("28");
        vSizes.add("32");
        vSizes.add("36");
        vSizes.add("40");
        vSizes.add("44");
        vSizes.add("48");
        vSizes.add("52");
        vSizes.add("56");
        vSizes.add("60");
        vSizes.add("64");
        vSizes.add("68");
        this.cboFontSize_ = new JComboBox(vSizes);
        DiagramProps props = new DiagramProps();
        LinkStrategy strategy = null;
        boolean clickActionsOn = true;
        if (this.isDiagramSet()) {
            props = this.diagram_.getDiagramProps();
            strategy = this.getRenderConfig().getLinkStrategy();
            clickActionsOn = this.getRenderConfig().getClickActionsOn();
        }
        DbVerbosity verbosity = new DbVerbosity();
        this.vbPanel_ = new VerbosityPanel(verbosity);
        this.displayColsPanel_ = new DisplayColumnsPanel(props);
        this.linkStrategyPanel = new LinkStrategyPanel(this.db_, strategy);
        this.fkNmsPanel = new ShowFkNmsEditPanel(props.getShowFkNames());
        this.erNotationPanel = new ErNotationSelectPanel(props.getErNotation());
        this.clickActionsEditPanel = new ClickActionsEditPanel(clickActionsOn);
        this.rectangleFillPanel = new RectangleFillOptionPanel(props.getDbTableRectangleFill());
    }

    private void layoutComponents() {
        this.buildTabPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getNamePanel(), "North");
        this.add((Component)this.tabs_, "Center");
        GuiHelper.addEmptyBorder(this);
    }

    private void buildTabPanel() {
        this.tabs_.add((Component)this.getDisplayPanel(), "Display");
        this.tabs_.add((Component)this.getRelationsPanel(), "Relations");
        this.tabs_.add((Component)this.getMiscPanel(), "Misc");
    }

    private JPanel getNamePanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.txtName_, gbc, panel, row++);
        return panel;
    }

    private JPanel getDisplayPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.displayColsPanel_);
        panel.add(Box.createVerticalStrut(4));
        panel.add(this.vbPanel_);
        panel.add(Box.createVerticalGlue());
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getMiscPanel() {
        int strutHeight = this.getStrutHeight();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.getFontPanel());
        panel.add(Box.createVerticalStrut(strutHeight));
        panel.add(this.clickActionsEditPanel);
        panel.add(Box.createVerticalStrut(strutHeight));
        panel.add(this.rectangleFillPanel);
        panel.add(Box.createVerticalStrut(150));
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getRelationsPanel() {
        int strutHeight = this.getStrutHeight();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.linkStrategyPanel);
        panel.add(Box.createVerticalStrut(strutHeight));
        panel.add(this.erNotationPanel);
        panel.add(Box.createVerticalStrut(strutHeight));
        panel.add(this.fkNmsPanel);
        panel.add(Box.createVerticalStrut(150));
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private void loadData() {
        if (this.isDiagramSet()) {
            this.txtName_.setText(this.diagram_.getName());
            RenderConfig rc = this.getRenderConfig();
            DbVerbosity verbosity = (DbVerbosity)rc.getVerbosityConfig();
            this.vbPanel_.setVerbosityConfig(verbosity);
            String fontSizeStr = Integer.toString(rc.getFont().getSize());
            this.cboFontSize_.setSelectedItem(fontSizeStr);
            this.clickActionsEditPanel.setClickActionsEnabled(rc.getClickActionsOn());
            this.linkStrategyPanel.setSelectedLinkStrategy(this.diagram_.getRenderConfig().getLinkStrategy());
        } else {
            this.txtName_.setText("");
            DbVerbosity vb = new DbVerbosity();
            int fontSize = 11;
            String strategyStr = "Primary Key to Foreign Key Column";
            if (this.optionMgr_ != null) {
                vb = this.getLastVbConfig();
                fontSize = this.optionMgr_.getIntValue("diagram.default.font.size");
            }
            this.displayColsPanel_.loadOptMgrSettings();
            this.fkNmsPanel.loadOptMgrSettings();
            this.erNotationPanel.loadOptMgrSettings();
            this.vbPanel_.setVerbosityConfig(vb);
            this.cboFontSize_.setSelectedItem(Integer.toString(fontSize));
            this.clickActionsEditPanel.setClickActionsEnabled(true);
            this.rectangleFillPanel.loadOptMgrSettings();
        }
    }

    private DbVerbosity getLastVbConfig() {
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        map.put(DbVerbosity.getKeyAutoNumber(), this.getBoolValue("diagram.show.autonum"));
        map.put(DbVerbosity.getKeyCheck(), new Boolean(false));
        map.put(DbVerbosity.getKeyComment(), this.getBoolValue("diagram.show.comment"));
        map.put(DbVerbosity.getKeyDataType(), this.getBoolValue("diagram.show.datatype"));
        map.put(DbVerbosity.getKeyDefault(), this.getBoolValue("diagram.show.default"));
        map.put(DbVerbosity.getKeyEnum(), this.getBoolValue("diagram.show.enum"));
        map.put(DbVerbosity.getKeyLength(), this.getBoolValue("diagram.show.length"));
        map.put(DbVerbosity.getKeyColumName(), this.getBoolValue("diagram.show.name"));
        map.put(DbVerbosity.getKeyNullable(), this.getBoolValue("diagram.show.null"));
        map.put(DbVerbosity.getKeySchemaName(), this.getBoolValue("diagram.show.schema"));
        map.put(DbVerbosity.getKeySigned(), this.getBoolValue("diagram.show.signed"));
        DbVerbosity vb = new DbVerbosity(map);
        return vb;
    }

    private Boolean getBoolValue(String key) {
        return new Boolean(this.optionMgr_.getBoolValue(key));
    }

    private void setCosmetics() {
        this.cboFontSize_.setPrototypeDisplayValue("000");
        this.txtName_.setToolTipText("");
        this.themeCtrl_.process(this);
    }

    private void setNames() {
        this.setName("DiagramEditPanel");
        this.lblName_.setName("lblName");
        this.txtName_.setName("txtName");
        this.vbPanel_.setName("vbPanel");
        this.cboFontSize_.setName("cboFontSize");
    }

    private void addListeners() {
    }

    public Diagram getDiagram() {
        this.validateData();
        return this.diagram_;
    }

    public Diagram getDiagramAsIs() {
        return this.diagram_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getDiagram();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 420, 480);
    }

    private void syncData() throws Exception {
        String newName = this.txtName_.getText();
        if (newName.equals("")) {
            throw new Exception("A diagram name must be specified.");
        }
        LinkStrategy oldStrategy = this.diagram_ != null ? this.diagram_.getRenderConfig().getLinkStrategy() : null;
        LinkStrategy strategy = this.linkStrategyPanel.getStrategy();
        Font newFont = this.extractNewFont();
        double zmLevel = this.isDiagramSet() ? this.diagram_.getZoom().getLevel() : 1.0;
        DbVerbosity vbConfig = (DbVerbosity)this.vbPanel_.getDataObject();
        RenderConfig rc = this.isDiagramSet() ? this.getRenderConfig() : new RenderConfig(1.0);
        rc.set(new Zoom(zmLevel));
        rc.set(vbConfig);
        rc.setLinkStrategy(strategy);
        rc.setFont(newFont);
        rc.setClickActionsOn(this.clickActionsEditPanel.getClickActionsEnabled());
        DiagramProps newProps = this.displayColsPanel_.getDiagramProps();
        newProps.setShowFkNames(this.fkNmsPanel.getShowFkNmsFlag());
        IErNotation erNotation = this.erNotationPanel.getErNotation();
        newProps.setErNotation(erNotation);
        IRectangleFill dbTableRectangleFill = this.rectangleFillPanel.getRectangleFill();
        newProps.setDbTableRectangleFill(dbTableRectangleFill);
        if (this.isDiagramSet()) {
            this.diagram_.setDiagramProps(newProps);
            String currentName = this.diagram_.getName();
            if (!currentName.equals(newName)) {
                Diagram nameTestDiagram = new Diagram(newName, rc, this.diagram_.getOnlyGlyphs());
                BasicCollector.verifyNoDups(this.db_, this.diagram_, nameTestDiagram);
                this.db_.rename(this.diagram_, currentName, newName);
            }
        } else {
            Diagram newDiagram = new Diagram(newName, rc, new ArrayList());
            ITestResult dupResult = BasicCollector.checkNotDuplicateAdd(this.db_, this.diagram_, newDiagram);
            if (!dupResult.getPassed()) {
                throw new Exception(dupResult.getDetail());
            }
            this.diagram_ = newDiagram;
        }
        this.storeOptions(strategy, newFont, vbConfig, newProps, erNotation, dbTableRectangleFill);
        new RightAngleLinksRefreshChecker().checkRefreshLinks(oldStrategy, strategy, this.diagram_);
        this.diagram_.refresh();
        this.loadData();
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        block2: {
            try {
                this.syncData();
                result = new DataEntryResult(true);
            }
            catch (Exception e) {
                LogUtil.logMsg(this, "Error: " + e.getMessage());
                result = new DataEntryResult(false, e.getMessage());
                if (!this.isDiagramSet()) break block2;
                this.loadData();
            }
        }
        return result;
    }

    private Font extractNewFont() {
        int fontSize = 11;
        try {
            fontSize = Integer.parseInt(this.cboFontSize_.getSelectedItem().toString());
        }
        catch (Exception e) {
            LogUtil.logErr("DiagramEditPanel couldn't parse font size: " + this.cboFontSize_.getSelectedItem().toString());
        }
        Font newFont = new Font("Verdana", 0, fontSize);
        return newFont;
    }

    private void storeOptions(LinkStrategy strategy, Font font, DbVerbosity vbCfg, DiagramProps props, IErNotation erNotation, IRectangleFill dbTableRectangleFill) {
        if (this.optionMgr_ != null) {
            int strategyId = strategy.getStrategyId();
            this.optionMgr_.setIntValue("diagram.default.strategy", strategyId);
            this.optionMgr_.setIntValue("diagram.default.font.size", font.getSize());
            this.storeBoolOpt("diagram.show.all.cols", props.getShowAllColumns());
            this.storeBoolOpt("diagram.show.autonum", vbCfg.getShowFlag(vbCfg.getKeyAutoNumber()));
            this.storeBoolOpt("diagram.show.all.cols", props.getShowAllColumns());
            this.storeBoolOpt("diagram.show.comment", vbCfg.getShowFlag(vbCfg.getKeyComment()));
            this.storeBoolOpt("diagram.show.datatype", vbCfg.getShowFlag(vbCfg.getKeyDataType()));
            this.storeBoolOpt("diagram.show.default", vbCfg.getShowFlag(vbCfg.getKeyDefault()));
            this.storeBoolOpt("diagram.show.enum", vbCfg.getShowFlag(vbCfg.getKeyEnum()));
            this.storeBoolOpt("diagram.show.fk.cols", props.getShowFkColumns());
            this.storeBoolOpt("diagram.show.fk.nms", props.getShowFkNames());
            this.storeBoolOpt("diagram.show.length", vbCfg.getShowFlag(vbCfg.getKeyLength()));
            this.storeBoolOpt("diagram.show.name", vbCfg.getShowFlag(vbCfg.getKeyColumName()));
            this.storeBoolOpt("diagram.show.null", vbCfg.getShowFlag(vbCfg.getKeyNullable()));
            this.storeBoolOpt("diagram.show.pk.cols", props.getShowPkColumns());
            this.storeBoolOpt("diagram.show.schema", vbCfg.getShowFlag(vbCfg.getKeySchemaName()));
            this.storeBoolOpt("diagram.show.signed", vbCfg.getShowFlag(vbCfg.getKeySigned()));
            this.storeTextOpt("diagram.er.notation", erNotation.getName());
            this.storeTextOpt("diagram.db.table.rectangle.fill", dbTableRectangleFill.getName());
        } else {
            LogUtil.logErr("DiaEditPanel.optMgr is NULL");
        }
    }

    private void storeTextOpt(String key, String value) {
        this.optionMgr_.setTextValue(key, value);
    }

    private void storeBoolOpt(String key, boolean bool) {
        this.optionMgr_.setBoolValue(key, bool);
    }

    public void update(UpdateChain chain) {
    }

    @Override
    public String getTitle() {
        StringBuffer sb = this.diagram_ == null ? new StringBuffer(ResMgr.getRes("add.label")) : new StringBuffer(ResMgr.getRes("edit.label"));
        sb.append(" " + App.getRes("diagram"));
        return sb.toString();
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.DIAGRAM;
    }

    @Override
    public Collector getCollector() {
        return this.db_;
    }
}

