/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.dnd.TransferWrapper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.panel.ForeignKeyPanel;
import com.harrand.dbwrenchgui.panel.TableDetailsPanel;
import com.harrand.sketch.command.AddGlyphs;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.util.LogUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class DbwDiagramPanelMouseHelper {
    private TableDetailsPanel tableDetailsPanel_ = null;
    private Diagram diagram_;
    private boolean showWarnings_ = true;

    public void setDiagram(Diagram diagram) {
        this.diagram_ = diagram;
    }

    public void setShowWarnings(boolean show) {
        this.showWarnings_ = show;
    }

    public boolean getShowWarnings() {
        return this.showWarnings_;
    }

    public Command getAddGlyphsCmd(List<Glyph> dropGlyphs, Point pt) {
        AddGlyphs cmd = null;
        ArrayList<Glyph> addGlyphs = new ArrayList<Glyph>();
        ArrayList<String> dupGlyphNms = new ArrayList<String>();
        for (Glyph glyph : dropGlyphs) {
            boolean alreadyIn = this.diagram_.getOnlyGlyphs().contains(glyph.getName());
            if (alreadyIn) {
                dupGlyphNms.add(glyph.getName());
                continue;
            }
            addGlyphs.add(glyph);
        }
        if (!dupGlyphNms.isEmpty()) {
            String title = "Warning - Duplicate Glyphs";
            String msg = "These tables already exist in this diagram: \n" + StrHelper.getLineFeedList(dupGlyphNms, true);
            if (this.showWarnings_) {
                GuiMessageHelper.showOptionPaneMsg(null, title, msg, 2);
            } else {
                LogUtil.logMsg(msg);
            }
        }
        if (!addGlyphs.isEmpty()) {
            cmd = new AddGlyphs(this.diagram_, addGlyphs, Command.getStateDo());
        }
        return cmd;
    }

    public JPanel getPropertyPanel(Glyph selectedGlyph) {
        JPanel propertyPanel;
        Database db = App.getDb();
        if (selectedGlyph instanceof DbTableGlyph) {
            DbTableGlyph tableGlyph = (DbTableGlyph)selectedGlyph;
            String tblDotNote = tableGlyph.getName();
            Table table = db.getTableFromDotNote(tblDotNote);
            if (this.tableDetailsPanel_ == null) {
                this.tableDetailsPanel_ = TableDetailsPanel.getInstance();
                this.tableDetailsPanel_.setTable(table);
            } else {
                this.tableDetailsPanel_.setTable(table);
            }
            propertyPanel = this.tableDetailsPanel_;
        } else if (selectedGlyph instanceof ForeignKeyGlyph) {
            ForeignKeyGlyph fkGlyph = (ForeignKeyGlyph)selectedGlyph;
            String fkDotNote = fkGlyph.getName();
            ForeignKey fk = db.getFkUtil().getFkFromDotNote(fkDotNote);
            propertyPanel = new ForeignKeyPanel(fk, db);
        } else {
            propertyPanel = new JPanel();
        }
        return propertyPanel;
    }

    private Identifiable parseIdf(Database db, String itemString) {
        Table idf = null;
        String[] parts = itemString.split(TransferWrapper.getFieldDelimiter());
        String mapName = parts[0];
        if (Table.getClassName().equals(mapName)) {
            String objName = parts[1];
            idf = db.getTableFromDotNote(objName);
        }
        return idf;
    }
}

