/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.worker.sql;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.db.DbDataResult;
import com.harrand.coreclasses.db.SqlHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.jdesktop.swingworker.IProcessObserver;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.subPanel.ServerStatusBar;
import com.harrand.dbwrench.db.JdbcHelper;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrenchgui.db.worker.helper.DbWorkerUpdateHelper;
import com.harrand.dbwrenchgui.db.worker.helper.SqlResultMsgBldr;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.openide.util.Exceptions;

public class SqlWorker
extends SwingWorker<ITestResult, ITestResult> {
    private IThreadObserver threadObserver;
    private final DbWorkerUpdateHelper updateHelper = new DbWorkerUpdateHelper();
    private Connection conn = null;
    private String execText = "Executing SQL";
    private List<String> sqlStrs;
    private List<String> translationMsgs;
    private IProcessObserver processObserver;

    @Override
    protected ITestResult doInBackground() throws Exception {
        DbDataResult result = null;
        try {
            this.updateHelper.displayConnecting();
            this.conn = ConnectionFactory.getConnection(this.getConfig());
            this.updateHelper.setStatusMsg(this.execText);
            int cmdIdx = -1;
            for (String sql : this.sqlStrs) {
                result = this.getRecordSetResult(sql, ++cmdIdx);
                this.publish(result);
            }
            this.closeConnection();
        }
        catch (Exception e) {
            result = this.getFailResult(e.getMessage());
        }
        return result;
    }

    private DbDataResult getRecordSetResult(String sql, int cmdIdx) throws Exception {
        DbDataResult result;
        long startTime = System.currentTimeMillis();
        Object[][] data = SqlHelper.getEmptyDataMatrix();
        boolean isRsNull = true;
        String errMsg = null;
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn, sql);
            if (rs != null) {
                data = JdbcHelper.rsToMatrix(rs);
                isRsNull = false;
            }
            result = new DbDataResult(true, data, isRsNull);
        }
        catch (Exception e) {
            errMsg = e.getMessage();
            result = new DbDataResult(false, data, isRsNull);
        }
        result.setElapsedMilliSec(System.currentTimeMillis() - startTime);
        result.setCmdText(sql);
        result.setCmdIndex(cmdIdx);
        SqlResultMsgBldr msgBldr = new SqlResultMsgBldr();
        String detailMsg = msgBldr.buildMsg(data, sql, this.getTranslationMsg(cmdIdx), result.getPassed(), errMsg);
        result.setDetail(detailMsg);
        return result;
    }

    @Override
    protected void process(List<ITestResult> chunks) {
        super.process(chunks);
        if (this.processObserver != null) {
            this.processObserver.process(chunks);
        }
    }

    @Override
    protected void done() {
        super.done();
        this.updateHelper.displayReady();
        if (this.threadObserver != null) {
            this.threadObserver.threadDone(this);
        }
        this.closeConnection();
    }

    public void startSqlCmd(String sql, IThreadObserver threadObserver) {
        ArrayList<String> sqlTexts = new ArrayList<String>();
        sqlTexts.add(sql);
        this.startSqlCmds(sqlTexts, threadObserver);
    }

    public void startSqlCmds(List<String> sqlStrs, IThreadObserver threadObserver) {
        this.sqlStrs = sqlStrs;
        this.threadObserver = threadObserver;
        try {
            this.execute();
        }
        catch (Exception ex) {
            this.updateHelper.handleExecuteException(ex, this.getClass().getName());
        }
    }

    public ITestResult getResult() {
        try {
            return (ITestResult)this.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new DataEntryResult(false);
        }
    }

    public void setProcessObserver(IProcessObserver processObserver) {
        this.processObserver = processObserver;
    }

    public void setDisabledButton(JButton btn) {
        this.updateHelper.setDisabledBtn(btn);
    }

    public void setSvrStatusBar(ServerStatusBar statusBar) {
        this.updateHelper.setSvrStatusDisplayer(statusBar);
    }

    public void setStatusLabel(JLabel lblStatus) {
        this.updateHelper.setStatusLabel(lblStatus);
    }

    public void setExecutingText(String execText) {
        this.execText = execText;
    }

    public void setTranslationMsgs(List<String> translationMsgs) {
        this.translationMsgs = translationMsgs;
    }

    private void closeConnection() {
        if (this.conn != null) {
            ConnectionFactory.close(this.conn);
            this.conn = null;
        }
    }

    private DbDataResult getFailResult(String message) {
        DbDataResult result = new DbDataResult(false, SqlHelper.getEmptyDataMatrix(), false);
        result.setSummary("SQL Statment Failed");
        result.setDetail(message);
        return result;
    }

    private JdbcConfig getConfig() {
        return ConnMgr.getInstance().getCurrentCfg();
    }

    private String getTranslationMsg(int cmdIdx) {
        if (this.translationMsgs == null) {
            return null;
        }
        if (cmdIdx < this.translationMsgs.size()) {
            return this.translationMsgs.get(cmdIdx);
        }
        return null;
    }
}

