/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.worker.meta;

import com.harrand.coreclasses.interfaces.IScript;
import com.harrand.coreclasses.interfaces.IScriptCtrl;
import com.harrand.coregui.display.status.IStatusDisplayer;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrenchgui.db.worker.helper.DbWorkerUpdateHelper;
import javax.swing.JButton;

public class SqlScriptWorker
extends SwingWorker<Void, Void> {
    private IThreadObserver threadObserver;
    private DbWorkerUpdateHelper updateHelper = new DbWorkerUpdateHelper();
    private JdbcConfig config;
    private IScript script;
    private IScriptCtrl scriptCtrl;

    @Override
    protected Void doInBackground() throws Exception {
        if (!this.updateHelper.isConfigValid(this.config)) {
            return null;
        }
        this.scriptCtrl.execute(this.config, this.script);
        return null;
    }

    @Override
    protected void done() {
        super.done();
        this.updateHelper.displayReady();
        this.threadObserver.threadDone(this);
    }

    public void setDisabledButton(JButton btn) {
        this.updateHelper.setDisabledBtn(btn);
    }

    public void setSvrStatusBar(IStatusDisplayer statusDisplay) {
        this.updateHelper.setSvrStatusDisplayer(statusDisplay);
    }

    public void startScript(JdbcConfig config, IScriptCtrl scriptCtrl, IScript script, IThreadObserver threadObserver) {
        this.config = config;
        this.scriptCtrl = scriptCtrl;
        this.script = script;
        this.threadObserver = threadObserver;
        try {
            this.execute();
        }
        catch (Exception ex) {
            this.updateHelper.handleExecuteException(ex, this.getClass().getName());
        }
    }
}

