/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.worker.meta;

import com.harrand.coreclasses.element.Version;
import com.harrand.coregui.display.status.IStatusDisplayer;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.IMetaDataCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchgui.db.worker.helper.DbWorkerUpdateHelper;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import org.openide.util.Exceptions;

public class RevEngWorker
extends SwingWorker<Database, Void> {
    private IMetaDataCtrl metaDataCtrl;
    private IThreadObserver threadObserver;
    private DbWorkerUpdateHelper updateHelper = new DbWorkerUpdateHelper();
    private JdbcConfig config;
    private boolean forRevSync;

    @Override
    public Database doInBackground() {
        if (!this.updateHelper.isConfigValid(this.config)) {
            return null;
        }
        Database revDb = null;
        this.updateHelper.displayConnecting();
        try {
            revDb = this.forRevSync ? this.revEngForRevSync() : this.revEngRegular();
        }
        catch (Exception e) {
            this.updateHelper.showSqlException(e);
            revDb = null;
        }
        return revDb;
    }

    @Override
    protected void done() {
        super.done();
        this.updateHelper.displayReady();
        this.threadObserver.threadDone(this);
    }

    public void setDisabledButton(JButton btn) {
        this.updateHelper.setDisabledBtn(btn);
    }

    public void setStatusDisplayer(IStatusDisplayer statusDisplayer) {
        this.updateHelper.setSvrStatusDisplayer(statusDisplayer);
    }

    public void setForRevSync(boolean forRevSync) {
        this.forRevSync = forRevSync;
    }

    public boolean getForRevSync() {
        return this.forRevSync;
    }

    private Database revEngRegular() throws Exception {
        this.setDbmsVersion();
        this.updateHelper.displayAnalysingSvr();
        Database revDb = this.metaDataCtrl.reverseEngineer();
        this.processDb(revDb);
        return revDb;
    }

    private Database revEngForRevSync() throws Exception {
        Database revDb = this.metaDataCtrl.revEngForSync();
        return revDb;
    }

    public void startRevEng(JdbcConfig config, IMetaDataCtrl metaDataCtrl, IThreadObserver threadObserver) {
        this.config = config;
        this.metaDataCtrl = metaDataCtrl;
        this.threadObserver = threadObserver;
        try {
            this.execute();
        }
        catch (Exception ex) {
            this.updateHelper.handleExecuteException(ex, this.getClass().getName());
        }
    }

    public Database getRevEngDb() {
        Database db = null;
        try {
            db = (Database)this.get();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return db;
    }

    private void setDbmsVersion() throws Exception {
        try {
            Version version = this.metaDataCtrl.getDbmsVersion();
            this.config.setVersion(version);
        }
        catch (Exception e) {
            this.updateHelper.handleExecuteException(e, this.getClass().getName());
            throw e;
        }
    }

    private void processDb(Database revDb) {
        revDb.addDefaultDiagram();
    }
}

