/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.viewData;

import com.harrand.coregui.Icons;
import com.harrand.dbwrench.element.CollectorProvider;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.TableDataPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class TableDataTopComponent
extends TopComponent {
    private TableDataPanel tableDataPanel;
    private Table table = null;
    private static TableDataTopComponent instance;
    public static final String PREFERRED_ID = "TableDataTopComponent";

    public TableDataTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(TableDataTopComponent.class, (String)"CTL_TableDataTopComponent"));
        this.setToolTipText(NbBundle.getMessage(TableDataTopComponent.class, (String)"HINT_TableDataTopComponent"));
        this.setIcon(Icons.getBufferedImage("table_data_viewer"));
    }

    public static String getTitle(Table tableStatic) {
        return tableStatic.getDotNote() + " Data";
    }

    private void setupGui() {
        this.setLayout(new BorderLayout());
        this.add(this.tableDataPanel, "Center");
    }

    private void loadTableData() {
        if (this.table == null) {
            this.table = CollectorProvider.getInstance().getTable();
        }
        this.setDisplayName(TableDataTopComponent.getTitle(this.table));
        if (this.tableDataPanel == null) {
            this.tableDataPanel = new TableDataPanel(this.table);
        }
        this.tableDataPanel.refresh();
    }

    public void componentOpened() {
        this.loadTableData();
        this.setupGui();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized TableDataTopComponent getDefault() {
        if (instance == null) {
            instance = new TableDataTopComponent();
        }
        return instance;
    }

    public static synchronized TableDataTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(TableDataTopComponent.class.getName()).warning("Cannot find TableDataTopComponent component. It will not be located properly in the window system.");
            return TableDataTopComponent.getDefault();
        }
        if (win instanceof TableDataTopComponent) {
            return (TableDataTopComponent)win;
        }
        Logger.getLogger(TableDataTopComponent.class.getName()).warning("There seem to be multiple components with the 'TableDataTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return TableDataTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }
}

