/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.xml.objects;

import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.xml.objects.DbQueryXmlCtrl;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DbQueriesXmlCtrl {
    private static final DbQueryXmlCtrl queryXmlCtrl = new DbQueryXmlCtrl();
    public static final String QUERIES_NM = "Queries";

    public Element asXmlElement(Document doc, List<DbQuery> queries) {
        Element elmDbQueries = doc.createElement(QUERIES_NM);
        for (DbQuery queryTbl : queries) {
            Element elmDbQuery = this.getQueryElm(doc, queryTbl);
            elmDbQueries.appendChild(elmDbQuery);
        }
        return elmDbQueries;
    }

    public static List<DbQuery> fromXml(Element elmQueries, Database db) {
        ArrayList<DbQuery> queries = new ArrayList<DbQuery>();
        NodeList elms = elmQueries.getElementsByTagName("Qry");
        if (elms == null) {
            return queries;
        }
        for (int i = 0; i < elms.getLength(); ++i) {
            Element elmDbQuery = (Element)elms.item(i);
            DbQuery query = DbQueriesXmlCtrl.getQuery(elmDbQuery, db);
            if (query == null) continue;
            queries.add(query);
        }
        return queries;
    }

    private Element getQueryElm(Document doc, DbQuery query) {
        return queryXmlCtrl.asXmlElement(doc, query);
    }

    private static DbQuery getQuery(Element elmQuery, Database db) {
        return DbQueryXmlCtrl.fromXml(elmQuery, db);
    }
}

