/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.panel.grid;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class QueryTableTableDriver
implements ITableDriver {
    private DbQuery query = new DbQuery("fillerQuery");
    private String className = QueryTable.getClassName();

    public void setQuery(DbQuery query) {
        this.query = query;
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.query.size(this.className)][this.getHeaders().length];
        int row = 0;
        for (QueryTable queryTable : this.query.getQueryTables()) {
            int col = 0;
            matrix[row][col++] = queryTable.getTable().getDotNote();
            matrix[row][col++] = queryTable.getTable().getDotNote();
            matrix[row][col++] = queryTable.getAlias();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"ID", "Table", "Alias"};
        return headers;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        String nm = (String)data.get("Table");
        String alias = (String)data.get("Alias");
        Table table = this.query.getDatabase().getTableFromDotNote(nm);
        QueryTable queryTable = this.query.getQueryTable(table);
        queryTable.setAlias(alias);
        return queryTable;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        list.add("Table");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Collector getCollector() {
        return this.query;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        return null;
    }

    @Override
    public String getIdfClassName() {
        return "QueryTable";
    }

    @Override
    public String getDisplayName() {
        return "Query Table";
    }

    @Override
    public String getDisplayPlural() {
        return "Query Tables";
    }
}

