/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.panel.general;

import com.harrand.coreclasses.element.IIdfAsIs;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.zoom.IZoomable;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.Icons;
import com.harrand.dbwrenchgui.db.query.diagram.cmd.QueryDiagramCmdBldr;
import com.harrand.dbwrenchgui.db.query.diagram.drawable.QueryDrawableOrderer;
import com.harrand.dbwrenchgui.db.query.diagram.layout.QueryTableLayouter;
import com.harrand.dbwrenchgui.db.query.diagram.nav.QueryNavPanelCtrl;
import com.harrand.dbwrenchgui.db.query.diagram.watermark.QueryWatermarkTextEngine;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.diagram.DbwDiagramDropListener;
import com.harrand.dbwrenchnb.db.query.window.ActivateQueryWindowsDisp;
import com.harrand.dbwrenchnb.diagram.tc.I_TC_Observer;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.interfaces.INavigatorSrc;
import com.harrand.sketch.j2d.DiagramPanel;
import com.harrand.sketch.panel.diagram.IDiagramScroller;
import com.harrand.sketch.zoom.disp.SetZoomDisp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public final class DbQueryPanel
extends JPanel
implements ITitled,
MouseMotionListener,
MouseListener,
IZoomable,
IIdfAsIs,
INavigatorSrc,
IDiagramScroller,
I_TC_Observer {
    private DbQuery query;
    private DiagramPanel diagramPanel;
    private JScrollPane scrollPane;
    private QueryNavPanelCtrl navPanelCtrl;

    public DbQueryPanel(DbQuery query) {
        this.query = query;
        this.init();
    }

    private void init() {
        this.setupGui();
        this.buildListeners();
        this.addListeners();
    }

    private void setupGui() {
        this.createComponents();
        this.layoutComponents();
        this.setCosmetics();
    }

    private void buildListeners() {
        this.scrollPane.addMouseMotionListener(this);
        this.scrollPane.addMouseListener(this);
        DbwDiagramDropListener dropLis = new DbwDiagramDropListener(this.diagramPanel);
        QueryTableLayouter layouter = new QueryTableLayouter(this.query);
        dropLis.setTableLayouter(layouter);
        this.diagramPanel.setDropTargetListener(dropLis);
        this.navPanelCtrl = new QueryNavPanelCtrl(this);
    }

    private void createComponents() {
        this.query.checkInitDiagram();
        this.diagramPanel = new DiagramPanel(this.query.getDiagram(), new QueryDrawableOrderer());
        this.diagramPanel.setWatermark(new QueryWatermarkTextEngine());
        this.diagramPanel.refresh();
        this.scrollPane = new JScrollPane(this.diagramPanel, 22, 32);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.scrollPane, "Center");
    }

    private void setCosmetics() {
        QueryDiagramCmdBldr queryDiagramCmdBldr = new QueryDiagramCmdBldr(this.query, this.getDiagram());
        this.diagramPanel.setDiagramCmdBldr(queryDiagramCmdBldr);
    }

    @Override
    public Diagram getDiagram() {
        return this.diagramPanel.getDiagram();
    }

    public DiagramPanel getDiagramPanel() {
        return this.diagramPanel;
    }

    @Override
    public String getTitle() {
        return this.query.getName();
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.QUERY_BLDR;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.diagramPanel.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.diagramPanel.mouseMoved(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.diagramPanel.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.diagramPanel.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.diagramPanel.mouseReleased(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.diagramPanel.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.diagramPanel.mouseExited(e);
    }

    @Override
    public void setZoom(Zoom zoom) {
        SetZoomDisp zoomDisp = new SetZoomDisp(this.diagramPanel, this.scrollPane);
        zoomDisp.setZoom(zoom);
    }

    @Override
    public Zoom getZoom() {
        if (this.getDiagram() != null) {
            return new Zoom(this.getDiagram().getZoom().getLevel());
        }
        return new Zoom(1.0);
    }

    @Override
    public Identifiable getIdfAsIs() {
        return this.query;
    }

    @Override
    public Collector getCollector() {
        return this.query.getDatabase();
    }

    @Override
    public Rectangle2D getPortal() {
        Rectangle vpRect = this.scrollPane.getViewport().getViewRect();
        return GeometryHelper.getRect2D(vpRect);
    }

    @Override
    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public IRefreshable getRefreshable() {
        return this.diagramPanel;
    }

    @Override
    public void tC_Activated() {
        this.navPanelCtrl.initNavTC();
        this.activateOtherQueryWindows();
    }

    @Override
    public void tC_Closed() {
        this.navPanelCtrl.clearNvSrc();
        this.diagramPanel.close();
        this.diagramPanel = null;
    }

    private void addListeners() {
        ActionListener lisDeleteSelected = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DbQueryPanel.this.diagramPanel.deleteSelected();
            }
        };
        this.registerKeyboardAction(lisDeleteSelected, KeyStroke.getKeyStroke(127, 0, false), 2);
    }

    private void activateOtherQueryWindows() {
        new ActivateQueryWindowsDisp().activate(this.query);
    }
}

