/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.objects.query;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryColumn;
import com.harrand.util.Validator;
import java.util.ArrayList;
import java.util.List;

public final class QueryTable
implements Identifiable {
    private Table table;
    private String alias;
    private int x;
    private int y;
    private List<QueryColumn> queryColumns = new ArrayList<QueryColumn>();
    private final DbQuery query;
    public static final String CLZ = "QueryTable";
    public static final String CLZ_DISPLAY = "Query Table";
    public static final String CLZ_DISPLAY_PL = "Query Tables";

    public QueryTable(DbQuery query, Table table) {
        this.query = query;
        this.table = table;
        this.initQueryColumns();
    }

    public Table getTable() {
        return this.table;
    }

    public DbQuery getQuery() {
        return this.query;
    }

    public List<QueryColumn> getQueryColumns() {
        return new ArrayList<QueryColumn>(this.queryColumns);
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isAliasSet() {
        return Validator.isStringValid(this.alias);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public String getName() {
        return this.table.getName();
    }

    public static String getClassName() {
        return QueryTable.class.getName();
    }

    public String getTableReferenceStr() {
        if (this.isAliasSet()) {
            return this.alias;
        }
        return this.getTableDotNote();
    }

    public String getTableFromStr() {
        String tableDotNote = this.getTableDotNote();
        if (this.isAliasSet()) {
            return tableDotNote + " AS " + this.alias;
        }
        return tableDotNote;
    }

    private String getTableDotNote() {
        return this.table.getDotNote();
    }

    public QueryColumn getQueryColumn(Column column) {
        for (QueryColumn queryColumn : this.queryColumns) {
            if (!queryColumn.getColumn().equals(column)) continue;
            return queryColumn;
        }
        return null;
    }

    private void initQueryColumns() {
        this.queryColumns = new ArrayList<QueryColumn>();
        for (Column column : this.table.getColumns()) {
            QueryColumn queryColumn = new QueryColumn(this, column);
            this.queryColumns.add(queryColumn);
        }
    }

    @Override
    public String getMapName() {
        return CLZ;
    }

    @Override
    public String getDisplayClzNm() {
        return CLZ_DISPLAY;
    }

    @Override
    public String getDisplayClzPlural() {
        return CLZ_DISPLAY_PL;
    }

    @Override
    public void setName(String newName) {
    }
}

