/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.objects.query;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.query.diagram.bldr.QueryDiagramBldr;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.dbwrenchgui.db.query.objects.select.ISelectLineObj;
import com.harrand.dbwrenchgui.db.query.objects.select.SelectLineObjsMgr;
import com.harrand.sketch.core.Diagram;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class DbQuery
implements Identifiable,
IObservable,
Collector {
    private String name;
    private List<QueryTable> queryTables = new ArrayList<QueryTable>();
    private SelectLineObjsMgr selectLinesObjsMgr = new SelectLineObjsMgr();
    private Database db;
    private Diagram diagram;
    private BasicObservable observable = new BasicObservable();

    public DbQuery(String name) {
        this.setName(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public List<QueryTable> getQueryTables() {
        return this.queryTables;
    }

    public void setQueryTables(List<QueryTable> queryTables) {
        this.queryTables = queryTables;
        this.notifyObservers(new UpdateChain(this));
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public List<Table> getTables() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (QueryTable queryTable : this.getQueryTables()) {
            tables.add(queryTable.getTable());
        }
        return tables;
    }

    public QueryTable getQueryTable(Table table) {
        for (QueryTable queryTable : this.getQueryTables()) {
            if (!table.equals(queryTable.getTable())) continue;
            return queryTable;
        }
        return null;
    }

    public boolean containsTable(Table table) {
        for (QueryTable queryTable : this.getQueryTables()) {
            if (!table.equals(queryTable.getTable())) continue;
            return true;
        }
        return false;
    }

    public Database getDatabase() {
        return this.db;
    }

    public void setDatabase(Database db) {
        this.db = db;
    }

    public static String getClassName() {
        return "DbQuery";
    }

    public void setSelectLinesObjsMgr(SelectLineObjsMgr selectLinesObjsMgr) {
        this.selectLinesObjsMgr = selectLinesObjsMgr;
    }

    public SelectLineObjsMgr getSelectLinesObjsMgr() {
        return this.selectLinesObjsMgr;
    }

    public void checkInitDiagram() {
        if (this.isDiagramSet()) {
            this.diagram = new QueryDiagramBldr().createDiagram(this);
        }
    }

    private boolean isDiagramSet() {
        return this.diagram == null;
    }

    public void addSelectObj(ISelectLineObj selectObj) {
        this.getSelectLinesObjsMgr().add(selectObj);
        this.notifyObservers(new UpdateChain(selectObj));
    }

    public void removeSelectObj(ISelectLineObj selectObj) {
        this.getSelectLinesObjsMgr().remove(selectObj);
        this.notifyObservers(new UpdateChain(selectObj));
    }

    @Override
    public String getMapName() {
        return DbQuery.getClassName();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public void addQueryTable(QueryTable queryTable) {
        this.queryTables.add(queryTable);
        this.notifyObservers(new UpdateChain(queryTable));
    }

    public void removeQueryTable(QueryTable queryTable) {
        this.queryTables.remove(queryTable);
        this.notifyObservers(new UpdateChain(queryTable));
    }

    @Override
    public int getObserverCount() {
        return this.observable.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable.removeObserver(observer);
    }

    @Override
    public ITestResult add(Identifiable idf) {
        this.addQueryTable((QueryTable)idf);
        return new DataEntryResult();
    }

    @Override
    public ITestResult updateItem(Identifiable oldIdf, Identifiable newIdf) {
        this.removeQueryTable((QueryTable)oldIdf);
        this.addQueryTable((QueryTable)newIdf);
        return new DataEntryResult();
    }

    @Override
    public void remove(String mapName, String identifiableName) {
    }

    @Override
    public void rename(Identifiable idf, String oldName, String newName) {
    }

    @Override
    public Identifiable get(String mapName, String identifiableName) {
        Table table = this.db.getTableFromDotNote(identifiableName);
        return this.getQueryTable(table);
    }

    @Override
    public int size(String mapName) {
        return this.queryTables.size();
    }

    @Override
    public List values(String mapName) {
        return this.queryTables;
    }

    @Override
    public Set getKeys(String mapName) {
        return new HashSet();
    }

    @Override
    public boolean contains(String mapName, String identifiableName) {
        return false;
    }

    @Override
    public String getDisplayName(String mapName) {
        return "";
    }

    @Override
    public String getDisplayPlural(String mapName) {
        return "";
    }

    @Override
    public ITestResult checkDuplicateName(String mapNm, String newNm) {
        return new DataEntryResult();
    }
}

