/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.diagram.glyph.column;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.object.Column;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.core.drawable.TextDrawable;
import com.harrand.sketch.interfaces.IPreImagedGlyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public final class QueryColumnNameGlyph
implements IDrawable,
ISized,
IPreImagedGlyph,
IRefreshable {
    private final Column column;
    private TextDrawable textDrawable;
    private String nm;
    private Rectangle imgRect;
    private BufferedImage img;
    private final IRenderConfigSrc rcSrc;

    public QueryColumnNameGlyph(Column column, IRenderConfigSrc rcSrc, Point origin) {
        this.column = column;
        this.rcSrc = rcSrc;
        this.nm = this.column.getName();
        this.textDrawable = new TextDrawable(this.nm, this.nm, this.getFont(), origin);
        this.calcImageSize();
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        g2.setPaint(Color.black);
        this.textDrawable.draw(g2, zoom);
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void setName(String newName) {
    }

    private void createImage() {
        this.calcImageSize();
        this.img = GuiHelper.getBufferedImage(this.imgRect.width, this.imgRect.height, true);
    }

    private void calcImageSize() {
        int width = GuiHelper.getSwingStringLength(this.nm, this.getFont());
        int height = GuiHelper.getSwingStringHeight(this.getFont());
        this.imgRect = new Rectangle(width, height);
    }

    private Font getFont() {
        return this.rcSrc.getRenderConfig().getFont();
    }

    private Zoom getZoom() {
        return this.rcSrc.getRenderConfig().getZoom();
    }

    public Point getOrigin() {
        return this.textDrawable.getOrigin();
    }

    public TextDrawable getTextDrawable() {
        return this.textDrawable;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return this.imgRect;
    }

    @Override
    public BufferedImage getImage() {
        if (this.img == null) {
            this.refresh();
        }
        return this.img;
    }

    @Override
    public void refresh() {
        this.createImage();
        this.draw((Graphics2D)this.img.getGraphics(), this.getZoom());
    }
}

