/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.diagram.drawable;

import com.harrand.coregui.mouse.IRollOverable;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.fk.FkGlyphExtractor;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.QueryTableGlyph;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.QueryTableGlyphExtractor;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.interfaces.IDiagramPlugin;
import com.harrand.sketch.interfaces.IHilightableGlyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.draw.IDrawableOrderer;
import com.harrand.sketch.j2d.shadow.RoundRectSpotShadowFactory;
import java.util.ArrayList;
import java.util.List;

public final class QueryDrawableOrderer
implements IDrawableOrderer {
    private Diagram diagram;
    private List<IDrawable> tblHighlightShapes = new ArrayList<IDrawable>();

    @Override
    public List<IDrawable> getOrderedDrawables(Diagram diagram) {
        ArrayList<IDrawable> drawables = new ArrayList<IDrawable>();
        this.setDiagram(diagram);
        List<QueryTableGlyph> glyphs = this.getQueryTableGlyphs();
        this.setHighLightedGlyphs();
        drawables.addAll(this.getShadows(glyphs));
        drawables.addAll(this.tblHighlightShapes);
        drawables.addAll(this.getFkGlyphs());
        drawables.addAll(glyphs);
        return drawables;
    }

    private void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    private List<QueryTableGlyph> getQueryTableGlyphs() {
        return new QueryTableGlyphExtractor().getQueryTableGlyphs(this.diagram);
    }

    private List<ForeignKeyGlyph> getFkGlyphs() {
        List<ForeignKeyGlyph> fkGlyphs = new FkGlyphExtractor().getFkGlyphs(this.diagram);
        return fkGlyphs;
    }

    private List<IDrawable> getShadows(List<QueryTableGlyph> glyphs) {
        double radius = 8.0;
        return new RoundRectSpotShadowFactory().getShadows(glyphs, radius);
    }

    private void setHighLightedGlyphs() {
        this.tblHighlightShapes = new ArrayList<IDrawable>();
        for (Glyph glyph : this.diagram.getAllGlyphs()) {
            boolean isMouseOver = this.getIsMouseOver(glyph);
            boolean selected = glyph.getSelected();
            if (!selected && !isMouseOver || !(glyph instanceof IHilightableGlyph)) continue;
            IHilightableGlyph hlGlyph = (IHilightableGlyph)((Object)glyph);
            List<IDrawable> hilightShapes = hlGlyph.getHilightDrawables(this.diagram);
            if (!(hlGlyph instanceof QueryTableGlyph)) continue;
            this.tblHighlightShapes.addAll(hilightShapes);
        }
    }

    private boolean getIsMouseOver(Glyph glyph) {
        boolean isOver = false;
        if (glyph instanceof IRollOverable) {
            IRollOverable rollOverable = (IRollOverable)((Object)glyph);
            isOver = rollOverable.isMouseOver();
        }
        return isOver;
    }

    @Override
    public void setDiagramPlugin(IDiagramPlugin diagramPlugin) {
        throw new UnsupportedOperationException("No plugins available yet");
    }
}

