/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.command.prompt.query;

import com.harrand.coregui.EditDialog;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.text.TextInputPanel;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.query.factory.QueryTableFactory;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.dbwrenchnb.action.query.ShowQueryWindowsCmd;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.tree.node.query.DbQueryNbNode;
import java.util.ArrayList;
import java.util.List;
import org.openide.windows.TopComponent;

public final class AddQueryCmd
extends Command {
    private Database db;
    private List<Table> tables;
    private final String name;
    private DbQuery newQuery;
    public static final String TC_NM = DbQueryNbNode.TC_NM;

    public AddQueryCmd(Database db, List<Table> tables) {
        this(db, tables, null, Command.getStateDo());
    }

    private AddQueryCmd(Database db, List<Table> tables, DbQuery newQuery, int state) {
        this.db = db;
        this.tables = new ArrayList<Table>(tables);
        this.name = "Add Query";
        this.newQuery = newQuery;
        this.setState(state);
        this.setProps();
    }

    @Override
    public Command duplicate() {
        AddQueryCmd cmdNew = new AddQueryCmd(this.db, this.tables, this.newQuery, this.getState());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        if (this.getState() == AddQueryCmd.getStateDo()) {
            this.showDlg();
        } else if (this.getState() == AddQueryCmd.getStateRedo()) {
            this.doForward();
        }
    }

    private String getNewQueryName() {
        return this.newQuery.getName();
    }

    private void showDlg() {
        TextInputPanel textPanel = new TextInputPanel("Query Name", "");
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, textPanel, textPanel.getPreferredBounds(), "Add Query");
        dlg.setVisible(true);
        String newNm = textPanel.getText();
        if (dlg.getOkHit()) {
            this.newQuery = new DbQuery(newNm);
            this.checkAddQueryTables();
            this.doForward();
        }
    }

    private void doForward() {
        this.db.add(this.newQuery);
        this.newQuery.setDatabase(this.db);
        this.openTC();
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
        this.db.remove(DbQuery.getClassName(), this.getNewQueryName());
        this.closeTC();
    }

    private void openTC() {
        new ShowQueryWindowsCmd(this.newQuery).actionPerformed(null);
    }

    private void checkAddQueryTables() {
        if (this.tables != null) {
            QueryTableFactory queryTableFactory = new QueryTableFactory();
            List<QueryTable> queryTables = queryTableFactory.createQueryTables(this.newQuery, this.tables);
            this.newQuery.setQueryTables(queryTables);
        }
    }

    private void closeTC() {
        TopComponent tc = NbUtil.findTopComponent(TC_NM, this.getNewQueryName());
        if (tc != null) {
            tc.close();
        }
    }
}

