/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.command.direct.table;

import com.harrand.coregui.command.Command;
import com.harrand.dbwrenchgui.db.query.diagram.glyph.table.QueryTableGlyph;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import com.harrand.sketch.core.Diagram;

public final class RemoveQueryTableCmd
extends Command {
    private DbQuery query;
    private QueryTable queryTable;
    private String cmdName;
    private QueryTableGlyph queryTableGlyph;
    private Diagram diagram;
    public static final String CMD_NM = "Remove Query Table";

    public RemoveQueryTableCmd(QueryTable queryTable) {
        this.init(queryTable, null);
        this.buildObject();
    }

    private RemoveQueryTableCmd(QueryTable queryTable, QueryTableGlyph queryTableGlyph) {
        this.init(queryTable, queryTableGlyph);
        this.buildObject();
    }

    private void init(QueryTable newQueryTable, QueryTableGlyph queryTableGlyph) {
        this.queryTable = newQueryTable;
        this.query = this.queryTable.getQuery();
        this.diagram = this.query.getDiagram();
        this.queryTableGlyph = queryTableGlyph;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName = CMD_NM;
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == RemoveQueryTableCmd.getStateDo()) {
            this.doForward();
        } else if (this.getState() == RemoveQueryTableCmd.getStateRedo()) {
            this.doForward();
        }
    }

    public void doForward() {
        this.query.removeQueryTable(this.queryTable);
        String queryTblNm = this.queryTable.getName();
        this.queryTableGlyph = (QueryTableGlyph)this.diagram.getGlyph(queryTblNm);
        this.diagram.removeGlyph(queryTblNm);
        this.diagram.refresh();
    }

    @Override
    protected void undo() {
        this.query.addQueryTable(this.queryTable);
        this.diagram.addGlyph(this.queryTableGlyph);
        this.diagram.refresh();
    }

    @Override
    public Command duplicate() {
        RemoveQueryTableCmd cmdNew = new RemoveQueryTableCmd(this.queryTable, this.queryTableGlyph);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", CMD_NM);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }
}

