/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.command.direct.Column;

import com.harrand.coregui.command.Command;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryColumn;

public class AddSelectQueryColumnCmd
extends Command {
    private DbQuery query;
    private QueryColumn queryColumn;
    private String cmdName;
    public static final String CMD_NM = "Add Query Column";

    public AddSelectQueryColumnCmd(QueryColumn queryColumn) {
        this.init(queryColumn);
        this.buildObject();
    }

    private AddSelectQueryColumnCmd(QueryColumn queryColumn, QueryColumn newQueryColumn) {
        this.init(newQueryColumn);
    }

    private void init(QueryColumn queryColumn) {
        this.queryColumn = queryColumn;
        this.query = this.queryColumn.getQueryTable().getQuery();
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName = "Add Query Column: " + this.queryColumn.getName();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == AddSelectQueryColumnCmd.getStateDo()) {
            this.doForward();
        } else if (this.getState() == AddSelectQueryColumnCmd.getStateRedo()) {
            this.doForward();
        }
    }

    public void doForward() {
        this.query.addSelectObj(this.queryColumn);
    }

    @Override
    protected void undo() {
        this.query.removeSelectObj(this.queryColumn);
    }

    @Override
    public Command duplicate() {
        AddSelectQueryColumnCmd cmdNew = new AddSelectQueryColumnCmd(this.queryColumn);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", CMD_NM);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }
}

