/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.bldr.select.alias;

import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrenchgui.db.query.bldr.select.alias.IColumnAliasBldr;
import com.harrand.dbwrenchgui.db.query.bldr.select.alias.MySqlColumnAliasBldr;
import com.harrand.dbwrenchgui.db.query.bldr.select.alias.OracleColumnAliasBldr;
import com.harrand.dbwrenchgui.db.query.bldr.select.alias.PsqlColumnAliasBldr;
import com.harrand.dbwrenchgui.db.query.bldr.select.alias.SqlSvrColumnAliasBldr;
import com.harrand.util.LogUtil;

public final class ColumnAliasBldrFactory {
    private ConnMgr connMgr = ConnMgr.getInstance();

    public IColumnAliasBldr getAliasBldr() {
        JdbcConfig cfg = this.getConfig();
        if (cfg == null) {
            LogUtil.logErr("ColumnAliasBldrFactory.err: JdbcConfig not set.");
            return null;
        }
        if (cfg.isMySql()) {
            return new MySqlColumnAliasBldr();
        }
        if (cfg.isOracle()) {
            return new OracleColumnAliasBldr();
        }
        if (cfg.isPsql()) {
            return new PsqlColumnAliasBldr();
        }
        if (cfg.isSqlSvr()) {
            return new SqlSvrColumnAliasBldr();
        }
        LogUtil.logErr("ColumnAliasBldrFactory.err: ColumnAliasBldr not found for: " + cfg.toString());
        return null;
    }

    private JdbcConfig getConfig() {
        return this.connMgr.getCurrentCfg();
    }
}

