/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db.query.bldr.pair;

import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.query.objects.from.JoinPair;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.dbwrenchgui.db.query.objects.query.QueryTable;
import java.util.ArrayList;
import java.util.List;

public final class JoinPairBldr {
    private DbQuery query;
    private List<JoinPair> joinPairs = new ArrayList<JoinPair>();

    public List<JoinPair> getJoinPairs(DbQuery query) {
        this.query = query;
        this.joinPairs = new ArrayList<JoinPair>();
        this.buildJoinPairs();
        return this.joinPairs;
    }

    private void buildJoinPairs() {
        for (Table table : this.query.getTables()) {
            for (ForeignKey fk : table.getFks()) {
                Table parTable;
                boolean isFkRepresented = this.getIsFkRepresented(fk);
                if (isFkRepresented || !this.getQueryContainsTable(parTable = fk.getParTbl())) continue;
                Table chdTable = fk.getChdTbl();
                QueryTable leftQueryTbl = this.query.getQueryTable(parTable);
                QueryTable rightQueryTbl = this.query.getQueryTable(chdTable);
                JoinPair joinPair = new JoinPair(leftQueryTbl, rightQueryTbl, fk);
                this.joinPairs.add(joinPair);
            }
        }
    }

    private boolean getQueryContainsTable(Table table) {
        return this.query.containsTable(table);
    }

    private boolean getIsFkRepresented(ForeignKey fk) {
        boolean matchFound = false;
        for (JoinPair joinPair : this.joinPairs) {
            ForeignKey connectingFk = joinPair.getConnectingForeignKey();
            if (!connectingFk.equals(fk)) continue;
            return true;
        }
        return matchFound;
    }
}

