/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db;

import com.google.common.base.Strings;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.text.FloatOnlyDoc;
import com.harrand.coregui.text.IntegerOnlyDoc;
import com.harrand.dbwrench.db.BasicDbValue;
import com.harrand.dbwrench.db.FkDataItem;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrenchgui.db.WidgetTextExtractor;
import com.harrand.dbwrenchgui.db.dataEdit.WidgetOverrideCtrl;
import com.harrand.util.LogUtil;
import java.awt.Font;
import java.text.DateFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class DbValueWidgetGroup {
    int widgetTypeId_ = -1;
    private final WidgetOverrideCtrl widgetOverrideCtrl = new WidgetOverrideCtrl();
    private final BasicDbValue dbValue_;
    private final Column column_;
    private final List domainValues_;
    private JLabel lblName_;
    private JLabel lblToolTip_;
    private JTextField txtField_;
    private JLabel lblField;
    private JComboBox combo_;
    private JCheckBox checkBox_;
    private JTextArea txtArea_;
    private boolean wantsFocus;
    public static final int INT_TXT_COLUMNS = 10;
    public static final int FLT_TXT_COLUMNS = 10;
    public static final int CHAR_LEN_TEXT_AREA = 75;
    public static final int TXT_AREA_LINES = 4;
    public static final int TEXT_FIELD_ID = 0;
    public static final int INT_FIELD_ID = 1;
    public static final int FLOAT_FIELD_ID = 2;
    public static final int TEXT_AREA_ID = 3;
    public static final int CHECK_BOX_ID = 4;
    public static final int COMBO_BOX_ID = 5;
    public static final int DATE_FIELD_ID = 6;
    static final String AUTONUMBER_TEXT = "(autonumber)";
    public static final int LINE_HEIGHT_PIXELS_DEFAULT = 25;
    public static final int FONT_SZ_EXPECTED = 11;
    private static final String USE_FOR_EMPTY_STRING_MESSAGE = "Use '' for empty string";

    public DbValueWidgetGroup(BasicDbValue dbValue, List domainValues) {
        this.dbValue_ = dbValue;
        this.domainValues_ = domainValues;
        this.column_ = this.dbValue_.getColumn();
        if (this.dbValue_ == null) {
            StrHelper.throwProgExcept("dbValue can not be null.");
        }
        this.buildControls();
    }

    public JLabel getNameLabel() {
        return this.lblName_;
    }

    public JLabel getTooltipLabel() {
        return this.lblToolTip_;
    }

    public JComponent getEditWidget() {
        if (this.combo_ != null) {
            return this.combo_;
        }
        if (this.txtField_ != null) {
            return this.txtField_;
        }
        if (this.txtArea_ != null) {
            return this.txtArea_;
        }
        if (this.checkBox_ != null) {
            return this.checkBox_;
        }
        if (this.lblField != null) {
            return this.lblField;
        }
        return null;
    }

    public void reset() {
        if (this.combo_ != null) {
            this.combo_.setSelectedIndex(0);
        } else if (this.txtField_ != null) {
            this.txtField_.setText("");
        } else if (this.txtArea_ != null) {
            this.txtArea_.setText("");
        } else if (this.checkBox_ != null) {
            this.checkBox_.setSelected(false);
        }
    }

    public ITestResult validateCurrentValue() {
        ITestResult result = new DataEntryResult(true);
        String newStr = null;
        if (this.txtField_ != null && this.txtField_.getText().length() > 0) {
            newStr = this.txtField_.getText();
        }
        if (this.txtArea_ != null && this.txtArea_.getText().length() > 0) {
            newStr = this.txtArea_.getText();
        }
        if (this.txtField_ != null || this.txtArea_ != null) {
            boolean treatAsStr;
            boolean isStrType = this.column_.getDataType().isStringLikeType();
            boolean useDefaultTextWidget = this.widgetOverrideCtrl.useDefaultTextWidget(this.column_);
            boolean bl = treatAsStr = isStrType || useDefaultTextWidget;
            if (treatAsStr && newStr == null) {
                newStr = "";
            }
            result = this.dbValue_.validateValue(newStr);
        }
        return result;
    }

    public BasicDbValue getCurrentValue() {
        BasicDbValue newDbValue = new BasicDbValue(this.column_, null, false);
        if (this.checkBox_ != null) {
            Boolean boolObj = this.checkBox_.isSelected();
            newDbValue = new BasicDbValue(this.column_, boolObj, false);
        } else if (this.combo_ != null) {
            if (this.combo_.getSelectedIndex() > 0) {
                FkDataItem fkItem = (FkDataItem)this.combo_.getSelectedItem();
                newDbValue = new BasicDbValue(this.column_, fkItem.getStrId(), false);
            }
        } else if (this.txtArea_ != null) {
            String strValue = new WidgetTextExtractor().extractText(this.txtArea_.getText());
            newDbValue = new BasicDbValue(this.column_, strValue, false);
        } else if (this.txtField_ != null) {
            ITestResult result = this.validateCurrentValue();
            if (result.getPassed()) {
                String strValue = new WidgetTextExtractor().extractText(this.txtField_.getText());
                newDbValue = new BasicDbValue(this.column_, strValue);
            }
        } else if (this.lblField != null) {
            String strValue = new WidgetTextExtractor().extractText(this.lblField.getText());
            newDbValue = new BasicDbValue(this.column_, strValue, false);
        } else {
            System.out.println("DbValueWidgetGroup.no widget initialized");
        }
        newDbValue.setIsNotOnServer(this.dbValue_.getIsNotOnServer());
        return newDbValue;
    }

    void setWantsFocus(boolean wantsFocus) {
        this.wantsFocus = wantsFocus;
    }

    public boolean getWantsFocus() {
        return this.wantsFocus;
    }

    public String getName() {
        return this.column_.getName();
    }

    public int getHeight() {
        int lineHeight = this.getLineHeightPixels();
        int height = this.getWidgetTypeId() == 3 ? 3 * lineHeight : lineHeight;
        return height;
    }

    private void setDefaultTextWidget(String strValue) {
        this.setWidgetTypeId(0);
        this.txtField_ = new JTextField(strValue);
    }

    private void setWidgetTypeId(int id) {
        this.widgetTypeId_ = id;
    }

    public int getWidgetTypeId() {
        return this.widgetTypeId_;
    }

    private void buildControls() {
        this.lblName_ = new JLabel(this.column_.getName());
        this.lblName_.setVerticalTextPosition(1);
        this.lblName_.setVerticalAlignment(1);
        this.lblToolTip_ = new JLabel(this.column_.getMetaDataDesc());
        this.buildWidget();
    }

    private void buildWidget() {
        IDataType dataType = this.column_.getDataType();
        int dataTypeId = dataType.getId();
        Object valueObj = this.dbValue_.getValueObject();
        boolean hasValue = valueObj != null;
        String strValue = "";
        if (hasValue) {
            strValue = valueObj.toString();
            if (dataTypeId == 1) {
                strValue = valueObj.toString().trim();
            }
        }
        if (this.widgetOverrideCtrl.useDefaultTextWidget(this.column_)) {
            this.setDefaultTextWidget(strValue);
        } else if (this.dbValue_.getIsNotOnServer()) {
            this.createLabelField("(column not on server)");
        } else if (this.domainValues_ != null && !this.domainValues_.isEmpty()) {
            this.setWidgetTypeId(5);
            Vector<FkDataItem> vector = new Vector<FkDataItem>(this.domainValues_);
            FkDataItem nullItem = new FkDataItem("null", "");
            vector.add(0, nullItem);
            this.combo_ = new JComboBox(new Vector(vector));
            this.combo_.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxx");
            if (hasValue) {
                this.selectCurrentComboValue();
            }
        } else if (dataType.isBooleanLikeType()) {
            this.setWidgetTypeId(4);
            this.checkBox_ = new JCheckBox(this.column_.getName());
            this.lblName_.setText("");
            if (hasValue) {
                if (valueObj instanceof Boolean) {
                    Boolean boolObj = (Boolean)valueObj;
                    this.checkBox_.setSelected(boolObj);
                } else if (valueObj instanceof String) {
                    String boolStr = (String)valueObj;
                    this.checkBox_.setSelected(StrHelper.getPsqlBoolean(boolStr));
                } else {
                    LogUtil.logErr("DbValueWidgetGroup.could not match boolean type.");
                }
            }
        } else if (this.column_.isIntegerColumn()) {
            this.setWidgetTypeId(1);
            if (!this.dbValue_.getColumn().getAutoNumber()) {
                IntegerOnlyDoc doc = new IntegerOnlyDoc();
                this.txtField_ = new JTextField();
                this.txtField_.setDocument(doc);
                this.txtField_.setText(strValue);
                this.setTextWidgetTooltip(this.txtField_);
            } else {
                String text = !Strings.isNullOrEmpty((String)strValue) ? strValue : AUTONUMBER_TEXT;
                this.createLabelField(text);
            }
        } else if (dataType.isDateLikeType()) {
            this.setWidgetTypeId(6);
            if (hasValue) {
                DateFormat formatter = dataType.getFormmatter();
                strValue = formatter.format(valueObj);
            }
            this.txtField_ = new JTextField(strValue, 10);
            this.setTextWidgetTooltip(this.txtField_);
        } else if (dataType.isNumberLikeType()) {
            this.setWidgetTypeId(2);
            FloatOnlyDoc doc = new FloatOnlyDoc();
            this.txtField_ = new JTextField(doc, strValue, 10);
            this.setTextWidgetTooltip(this.txtField_);
        } else if (dataTypeId == 703 || dataTypeId == 723 || dataTypeId == 710 || dataTypeId == 711 || dataTypeId == 712) {
            this.setWidgetTypeId(3);
            this.txtArea_ = this.getTextArea(strValue);
        } else if ((dataTypeId == 12 || dataTypeId == 1 || dataTypeId == 724 || dataTypeId == 722) && this.isLongText()) {
            this.setWidgetTypeId(3);
            this.txtArea_ = this.getTextArea(strValue);
        } else if (dataType.isBlobLikeType()) {
            this.setWidgetTypeId(3);
            this.txtArea_ = this.getTextArea(strValue);
        } else {
            this.setDefaultTextWidget(strValue);
        }
    }

    private void createLabelField(String text) {
        this.lblField = new JLabel(text);
        GuiHelper.addEmptyBorder(this.lblField);
    }

    private boolean isLongText() {
        boolean nullLength;
        boolean isLong = true;
        Integer lengthInt = this.column_.getLength();
        boolean bl = nullLength = lengthInt == null;
        if (!nullLength && lengthInt < 75) {
            isLong = false;
        }
        return isLong;
    }

    private JTextArea getTextArea(String text) {
        JTextArea txtArea = new JTextArea(text);
        txtArea.setRows(4);
        txtArea.setLineWrap(true);
        txtArea.setWrapStyleWord(true);
        Font font = this.lblName_.getFont();
        txtArea.setFont(font);
        txtArea.setToolTipText(USE_FOR_EMPTY_STRING_MESSAGE);
        return txtArea;
    }

    private void selectCurrentComboValue() {
        if (this.column_.getDataTypeId() == 706) {
            this.selectCurrentComboValueEnum();
        } else {
            this.selectCurrentComboValueFk();
        }
    }

    private void selectCurrentComboValueFk() {
        String strId = "";
        Object valueObj = this.dbValue_.getValueObject();
        strId = valueObj instanceof Integer ? ((Integer)valueObj).toString() : valueObj.toString();
        int itemCount = this.combo_.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            FkDataItem fkDataItem = (FkDataItem)this.combo_.getItemAt(i);
            if (!strId.equals(fkDataItem.getStrId())) continue;
            this.combo_.setSelectedIndex(i);
        }
    }

    private void selectCurrentComboValueEnum() {
        String currentDesc = (String)this.dbValue_.getValueObject();
        int itemCount = this.combo_.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            FkDataItem fkDataItem = (FkDataItem)this.combo_.getItemAt(i);
            String itemDesc = fkDataItem.getDesc();
            if (!currentDesc.equals(itemDesc)) continue;
            this.combo_.setSelectedIndex(i);
        }
    }

    public int getLineHeightPixels() {
        int fontSz = this.lblName_.getFont().getSize();
        int lineHeight = 25;
        if (fontSz > 11) {
            int diffSz = fontSz - 11;
            lineHeight += 2 * diffSz;
        }
        return lineHeight;
    }

    private void setTextWidgetTooltip(JComponent component) {
        component.setToolTipText(USE_FOR_EMPTY_STRING_MESSAGE);
    }
}

