/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.db.BasicDbValue;
import com.harrand.dbwrench.db.RowDataCtrl;
import com.harrand.dbwrench.db.TableDataCtrl;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.DbValueWidgetGroup;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;

public final class DbRowEditPanelCtrl
implements IThreadObserver {
    private final Database db_;
    private final Table table_;
    private JdbcConfig config_;
    private RowDataCtrl rowDataCtrl_;
    private TableDataCtrl tableCtrl_ = null;
    private List widgetGroups_;
    private JButton disabledBtn;
    private JLabel statusLbl;
    private ITestResult sqlCmdResult;
    private IThreadObserver externalThreadObserver;
    private int selectedGridCol;
    public static final int PREFERRED_WIDTH = 350;

    public DbRowEditPanelCtrl(Table table) {
        this.table_ = table;
        this.db_ = this.table_.getSchema().getDb();
        this.initRowCtrl();
    }

    public void setConfig(JdbcConfig config) {
        boolean hasChanged = !MathUtil.isEquivalent(this.config_, config);
        this.config_ = config;
        this.rowDataCtrl_.setConfig(this.config_);
        this.tableCtrl_ = this.isConfigSet() ? new TableDataCtrl(this.db_, this.table_, this.config_) : null;
        if (hasChanged) {
            this.buildWidgetGroups();
        }
    }

    private void initRowCtrl() {
        this.rowDataCtrl_ = new RowDataCtrl(this.table_);
        this.rowDataCtrl_.setDisabledBtn(this.disabledBtn);
        this.rowDataCtrl_.setStatusLabel(this.statusLbl);
        this.rowDataCtrl_.setThreadObserver(this);
    }

    public void setCurrentValues(Map currentValues) {
        this.rowDataCtrl_.setCurrentValues(currentValues);
    }

    public void setSelectedGridColumn(int selectedGridCol) {
        this.selectedGridCol = selectedGridCol;
    }

    public int getSelectedGridCol() {
        return this.selectedGridCol;
    }

    public ITestResult getSqlCmdResult() {
        return this.sqlCmdResult;
    }

    public void setDisabledBtn(JButton disabledBtn) {
        this.disabledBtn = disabledBtn;
    }

    public void setStatusLabel(JLabel statusLbl) {
        this.statusLbl = statusLbl;
    }

    public void setThreadObserver(IThreadObserver threadObserver) {
        this.externalThreadObserver = threadObserver;
    }

    public RowDataCtrl getRowCtrl() {
        return this.rowDataCtrl_;
    }

    public Map<String, BasicDbValue> getCurrentValues() {
        return this.rowDataCtrl_.getCurrentValues();
    }

    public Object getCurrentValue(String columnName) {
        return this.rowDataCtrl_.getCurrentValueObject(columnName);
    }

    public List getWidgetGroups() {
        return this.widgetGroups_;
    }

    public void resetWidgets() {
        for (DbValueWidgetGroup group : this.widgetGroups_) {
            group.reset();
        }
    }

    public Rectangle getPreferredBounds() {
        int totalHeight = 0;
        for (int i = 0; i < this.widgetGroups_.size(); ++i) {
            DbValueWidgetGroup group = (DbValueWidgetGroup)this.widgetGroups_.get(i);
            int height = group.getHeight();
            totalHeight += height;
        }
        return new Rectangle(350, totalHeight);
    }

    public ITestResult startInsert() {
        ITestResult result = this.validateGuiValues();
        if (result.getPassed()) {
            Map<String, BasicDbValue> newDbValues = this.getGuiDbValues();
            this.rowDataCtrl_.setDisabledBtn(this.disabledBtn);
            result = this.rowDataCtrl_.startRowInsert(newDbValues);
        }
        return result;
    }

    public ITestResult startUpdate() {
        ITestResult result = this.validateGuiValues();
        if (result.getPassed()) {
            Map<String, BasicDbValue> newDbValues = this.getGuiDbValues();
            this.rowDataCtrl_.setDisabledBtn(this.disabledBtn);
            result = this.rowDataCtrl_.startRowUpdate(newDbValues);
        }
        return result;
    }

    public ITestResult startDelete() {
        this.rowDataCtrl_.setDisabledBtn(this.disabledBtn);
        ITestResult result = this.rowDataCtrl_.startRowDelete();
        return result;
    }

    public String getInsertSql() {
        Map<String, BasicDbValue> newDbValues = this.getGuiDbValues();
        String sql = this.rowDataCtrl_.getInsertSql(newDbValues);
        return sql;
    }

    public String getUpdateSql() {
        Map<String, BasicDbValue> newDbValues = this.getGuiDbValues();
        String sql = this.rowDataCtrl_.getUpdateSql(newDbValues);
        return sql;
    }

    public String getDeleteSql() {
        String sql = this.rowDataCtrl_.getDeleteSql();
        return sql;
    }

    private void buildWidgetGroups() {
        this.widgetGroups_ = new ArrayList();
        int i = 0;
        for (BasicDbValue dbValue : this.getCurrentValues().values()) {
            List domainValues = this.tableCtrl_ != null ? this.tableCtrl_.getDomainValues(dbValue.getColumn().getName()) : null;
            DbValueWidgetGroup widgetGroup = new DbValueWidgetGroup(dbValue, domainValues);
            this.widgetGroups_.add(widgetGroup);
            if (i == this.selectedGridCol) {
                widgetGroup.setWantsFocus(true);
            }
            ++i;
        }
    }

    private Map<String, BasicDbValue> getGuiDbValues() {
        LinkedHashMap<String, BasicDbValue> guiDbValues = new LinkedHashMap<String, BasicDbValue>();
        for (DbValueWidgetGroup widgetGroup : this.getWidgetGroups()) {
            BasicDbValue newDbValue = widgetGroup.getCurrentValue();
            if (newDbValue == null) {
                LogUtil.logErr("DbRowEditPanelCtrl.widgetGroup: " + widgetGroup.getName() + " has NULL dbValue");
            }
            guiDbValues.put(widgetGroup.getName(), newDbValue);
        }
        return guiDbValues;
    }

    private ITestResult validateGuiValues() {
        DataEntryResult result = new DataEntryResult(true);
        StringBuilder sb = new StringBuilder();
        for (DbValueWidgetGroup widgetGroup : this.getWidgetGroups()) {
            ITestResult widgetResult = widgetGroup.validateCurrentValue();
            if (widgetResult.getPassed()) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(widgetResult.getDetail());
        }
        if (sb.length() > 0) {
            result = new DataEntryResult(false, sb.toString());
        }
        return result;
    }

    public boolean isConfigSet() {
        return this.config_ != null;
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        this.sqlCmdResult = this.rowDataCtrl_.getSqlCmdResult();
        this.externalThreadObserver.threadDone(threadWorker);
    }
}

