/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.db;

import com.harrand.coreclasses.dataEntry.IClosableMgr;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IStorable;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.Icons;
import com.harrand.coregui.dialog.DataEditDlg;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.image.IIconTabPane;
import com.harrand.coregui.label.StatusLabel;
import com.harrand.coregui.list.ComboPanel;
import com.harrand.coregui.panel.StatusPanel;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.db.TableDataPanel;
import com.harrand.dbwrenchgui.panel.JdbcConfigListPanel;
import com.harrand.util.MathUtil;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class DataViewerPanel
extends JPanel
implements ISized,
IObserver,
IClosableMgr,
IStorable,
IIconTabPane,
ITitled {
    private DbUser user_;
    private Database db_;
    private JdbcConfig config_;
    private JdbcConfigListPanel configPanel_;
    private JDialog parentDlg_;
    private IOptionMgr forEngOptMgr_;
    private List tables_ = new ArrayList();
    private List dataPanels_ = new ArrayList();
    private JTabbedPane tabs_ = new JTabbedPane(3);
    private JButton btnAddDataView_ = new JButton(ResMgr.getRes("data.view.add"));
    private ActionListener lisAddDataView_;
    private StatusLabel emptyStatus_;
    private StatusLabel serverStatus_;
    private StatusLabel dbStatus_;
    private StatusPanel statusPanel_;
    private SwingThemeCtrl themeCtrl_;
    public static final String CLAZZ = "DataViewerPanel";
    public static final String TITLE = ResMgr.getRes("table.data.viewer");

    public DataViewerPanel(DbUser user, Database db, JdbcConfig config) {
        this.user_ = user;
        this.db_ = db;
        this.forEngOptMgr_ = user.getOptionMgr("forward.engineer.option.mgr");
        this.configPanel_ = new JdbcConfigListPanel(this.user_);
        this.updateFilterConns();
        if (config != null) {
            this.configPanel_.setConfig(config);
        }
        this.config_ = (JdbcConfig)this.configPanel_.getSelectedConfig();
        this.configPanel_.addObserver(this);
        this.themeCtrl_ = App.getThemeCtrl();
        this.setupGui();
    }

    public void setDb(Database db) {
        this.closeAllDataPanels();
        this.tabs_.removeAll();
        this.tables_ = new ArrayList();
        this.dataPanels_ = new ArrayList();
        this.db_ = db;
        this.updateFilterConns();
        this.updateConfig();
    }

    @Override
    public void setIconAt(int pos, Icon icon) {
        if (pos >= 0 && pos < this.tabs_.getTabCount()) {
            this.tabs_.setIconAt(pos, icon);
        }
    }

    @Override
    public Icon getIconAt(int pos) {
        Icon icon = null;
        if (pos >= 0 && pos < this.tabs_.getTabCount()) {
            icon = this.tabs_.getIconAt(pos);
        }
        return icon;
    }

    public void addTable(Table table) {
    }

    public List getTables() {
        return this.tables_;
    }

    public void setParentDialog(JDialog parentDlg) {
        this.parentDlg_ = parentDlg;
    }

    public JdbcConfig getConfig() {
        return this.config_;
    }

    private void updateFilterConns() {
        boolean filterConns = this.forEngOptMgr_.getBoolValue("forward.engineer.filter.conn");
        if (filterConns) {
            this.configPanel_.setFilterDatabase(this.db_);
        }
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.buildStatusPanel();
        this.updateConfigStatus();
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)this.tabs_, "Center");
        this.add((Component)this.statusPanel_, "South");
    }

    private JPanel getTopPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        JPanel btnPanel = new JPanel(new BorderLayout(4, 4));
        btnPanel.setBorder(GuiHelper.getEmptyBorder());
        btnPanel.add(this.btnAddDataView_);
        this.themeCtrl_.process(btnPanel);
        panel.setBorder(GuiHelper.getEmptyBorder());
        panel.add((Component)this.configPanel_, "West");
        panel.add((Component)btnPanel, "East");
        this.themeCtrl_.process(panel);
        return panel;
    }

    private void buildStatusPanel() {
        this.emptyStatus_ = new StatusLabel(60, " ", null);
        this.serverStatus_ = new StatusLabel(15, StrHelper.UNSPECIFIED_STR, Icons.SERVER);
        this.dbStatus_ = new StatusLabel(15, this.db_.getName(), Icons.DATABASE);
        this.serverStatus_.setToolTipText(ResMgr.getRes("server.label"));
        this.dbStatus_.setToolTipText(App.getRes("database.label"));
        ArrayList<StatusLabel> labels = new ArrayList<StatusLabel>();
        labels.add(this.emptyStatus_);
        labels.add(this.serverStatus_);
        labels.add(this.dbStatus_);
        this.statusPanel_ = new StatusPanel(labels, true);
    }

    private void setCosmetics() {
        this.btnAddDataView_.setMnemonic(65);
    }

    private void setNames() {
        this.setName(TITLE);
        this.tabs_.setName("tabs");
        this.btnAddDataView_.setName("btnAddDataView");
    }

    private void addListeners() {
        this.lisAddDataView_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataViewerPanel.this.showTableCombo();
            }
        };
        this.btnAddDataView_.addActionListener(this.lisAddDataView_);
    }

    private void showTableCombo() {
        Object obj;
        List tblNms = this.db_.getAllTableNmsOptionBrackets();
        Vector vTables = new Vector(tblNms);
        String prompt = ResMgr.getRes("data.view.from");
        String title = ResMgr.getRes("data.view.add");
        ComboPanel comboPanel = new ComboPanel(vTables, prompt, title);
        comboPanel.setIcon(Icons.TABLE_DATA);
        DataEditDlg dlg = new DataEditDlg(comboPanel, null);
        dlg.setVisible(true);
        if (dlg.getOkHit() && (obj = comboPanel.getSelectedItem()) != null && obj instanceof String) {
            String tblNm = (String)obj;
            Table tbl = null;
            if (this.db_.getHasManySchemas()) {
                tbl = this.db_.getTableFromSchemaBracket(tblNm);
            } else {
                Schema firstSch = this.db_.getFirstSchema();
                tbl = firstSch.getTable(tblNm);
            }
            this.addTable(tbl);
        }
    }

    private void updateConfig() {
        JdbcConfig newConfig = this.configPanel_.getConfigCount() > 0 ? (JdbcConfig)this.configPanel_.getSelectedConfig() : null;
        boolean hasChanged = !MathUtil.isEquivalent(this.config_, newConfig);
        this.config_ = newConfig;
        this.updateConfigStatus();
        if (hasChanged) {
            this.refreshDataPanels();
        }
    }

    private void updateConfigStatus() {
        String serverName = this.config_ != null ? this.config_.getServer() : StrHelper.UNSPECIFIED_STR;
        this.serverStatus_.setText(serverName);
    }

    private void refreshDataPanels() {
        for (TableDataPanel tableDataPanel : this.dataPanels_) {
        }
    }

    private void closeAllDataPanels() {
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.TABLE_DATA_VIEWER;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    private boolean tableExists(Table table) {
        return this.getIndexOfTable(table) >= 0;
    }

    private void selectTable(Table table) {
        int idx = this.getIndexOfTable(table);
        if (idx >= 0) {
            this.tabs_.setSelectedIndex(idx);
        }
    }

    public int getIndexOfTable(Table tbl) {
        int idx = -1;
        for (int i = 0; i < this.tabs_.getTabCount() && idx < 0; ++i) {
            String title = this.tabs_.getTitleAt(i);
            if (!title.equalsIgnoreCase(tbl.getName()) && !title.equalsIgnoreCase(tbl.getDotNote())) continue;
            idx = i;
        }
        return idx;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 500, 350);
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(JdbcConfigListPanel.class.getName())) {
            this.updateConfig();
        }
    }

    @Override
    public String getStorageName() {
        return CLAZZ;
    }

    @Override
    public void closeDisplay(String dotNote) {
        int idx = this.getIndexOfTable(this.db_.getTableFromDotNote(dotNote));
        if (idx >= 0) {
            this.tabs_.remove(idx);
            this.tables_.remove(idx);
            this.dataPanels_.remove(idx);
        }
    }
}

