/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.table;

import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.viewData.TableDataTopComponent;
import com.harrand.dbwrenchnb.nb.NbUtil;
import org.openide.windows.TopComponent;

public class ShowTableDataTC
extends Command {
    private Table table;
    private String cmdName_;

    public ShowTableDataTC(Table table) {
        this.init(table);
        this.buildObject();
    }

    private void init(Table table) {
        this.table = table;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName_ = "Show Table Data";
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == ShowTableDataTC.getStateDo()) {
            this.doForward();
        } else if (this.getState() == ShowTableDataTC.getStateRedo()) {
            this.doForward();
        }
    }

    public void doForward() {
        String TC_title;
        String tcClassNm = TableDataTopComponent.class.getName();
        TopComponent existingTc = NbUtil.findTopComponent(tcClassNm, TC_title = TableDataTopComponent.getTitle(this.table));
        if (existingTc == null) {
            this.showNew();
        } else {
            existingTc.requestActive();
        }
    }

    private void showNew() {
        TableDataTopComponent TC = new TableDataTopComponent();
        TC.open();
        TC.requestActive();
    }

    @Override
    protected void undo() {
    }

    @Override
    public Command duplicate() {
        ShowTableDataTC cmdNew = new ShowTableDataTC(this.table);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", "View Table Data");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.TABLE);
    }
}

