/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.table;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.text.TextInputPanel;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.command.table.ChangeTableProps;
import com.harrand.dbwrenchgui.command.table.PromptTableProps;
import com.harrand.util.ResMgr;

public class PromptTableRenameCmd
extends Command {
    private Table table;
    private String cmdName_;

    public PromptTableRenameCmd(Table table) {
        this.init(table);
        this.buildObject();
    }

    private void init(Table table) {
        this.table = table;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName_ = "Update Table Properties For : " + this.table.getDotNote();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == PromptTableRenameCmd.getStateDo()) {
            this.showDlg();
        } else if (this.getState() == PromptTableRenameCmd.getStateRedo()) {
            this.doForward();
        }
    }

    private void showDlg() {
        String oldName = this.table.getName();
        TextInputPanel editor = new TextInputPanel(ResMgr.getRes("rename.prompt"), oldName);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editor, editor.getPreferredBounds(), ResMgr.getRes("rename.label"));
        dlg.setVisible(true);
        String newName = editor.getText();
        if (dlg.getOkHit()) {
            DataEntryResult rslt;
            Schema schema = this.table.getSchema();
            ITestResult iTestResult = rslt = oldName.equalsIgnoreCase(newName) ? new DataEntryResult(true) : schema.checkDuplicateName(this.table.getMapName(), newName);
            if (rslt.getPassed()) {
                ChangeTableProps changeCmd = new ChangeTableProps(this.table, newName, this.table.getComment(), this.table.getTableOptions());
                changeCmd.actionPerformed(null);
            } else {
                GuiMessageHelper.showInputErrMsg(null, rslt);
                this.showDlg();
            }
        } else {
            this.setCommandChain(null);
        }
    }

    public void doForward() {
    }

    @Override
    protected void undo() {
    }

    @Override
    public Command duplicate() {
        PromptTableProps cmdNew = new PromptTableProps(this.table);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", "Prompt Table Properties");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.TABLE);
    }
}

