/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.table;

import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.panel.TablePropPanel;

public class PromptTableProps
extends Command {
    private Table table;
    private String cmdName_;
    private RenameIdf cmdRnm;
    private String oldCmm;
    private String newCmm;
    private String oldTblOpts;
    private String newTblOpts;

    public PromptTableProps(Table table) {
        this.init(table, null, table.getComment(), "", table.getTableOptions(), "");
        this.buildObject();
    }

    private PromptTableProps(Table table, RenameIdf cmdRnm, String oldCmm, String newCmm, String oldTblOpts, String newTblOpts) {
        this.init(table, cmdRnm, oldCmm, newCmm, oldTblOpts, newTblOpts);
    }

    private void init(Table table, RenameIdf cmdRnm, String oldCmm, String newCmm, String oldTblOpts, String newTblOpts) {
        this.table = table;
        this.cmdRnm = cmdRnm;
        this.oldCmm = oldCmm;
        this.newCmm = newCmm;
        this.oldTblOpts = oldTblOpts;
        this.newTblOpts = newTblOpts;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName_ = "Update Table Properties For : " + this.table.getDotNote();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == PromptTableProps.getStateDo()) {
            this.showDlg();
        } else if (this.getState() == PromptTableProps.getStateRedo()) {
            this.doForward();
        }
    }

    private void showDlg() {
        TablePropPanel editor = new TablePropPanel(this.table);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editor);
        editor.setSyncOnEdit(false);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            String newName = editor.getTableName();
            this.cmdRnm = new RenameIdf(this.table.getSchema(), this.table, this.table.getName(), newName, null);
            this.newCmm = editor.getComment();
            this.newTblOpts = editor.getTableOptions();
        } else {
            this.setCommandChain(null);
        }
    }

    public void doForward() {
    }

    @Override
    protected void undo() {
    }

    @Override
    public Command duplicate() {
        PromptTableProps cmdNew = new PromptTableProps(this.table, this.cmdRnm, this.oldCmm, this.newCmm, this.oldTblOpts, this.newTblOpts);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", "Prompt Table Properties");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.TABLE);
    }
}

