/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.table;

import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.text.TextInputPanel;
import com.harrand.dbwrench.db.table.CloneTableCommand;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;

public final class PromptCloneTable
extends Command {
    public static final String CLONE_NAME_SUFFIX = "_dup";
    private Table tableToClone;
    private Diagram diagram;
    public static final String DISPLAY = "Clone Table";

    public PromptCloneTable(Table toCloneTable, Diagram diagram) {
        this.tableToClone = toCloneTable;
        this.diagram = diagram;
        this.setProps();
    }

    @Override
    protected void execute() {
        String currentTableName = this.tableToClone.getName();
        String cloneTableDefaultName = currentTableName + CLONE_NAME_SUFFIX;
        TextInputPanel editor = new TextInputPanel("Cloned Table Name", cloneTableDefaultName);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editor, editor.getPreferredBounds(), DISPLAY);
        dlg.setVisible(true);
        String newName = editor.getText();
        if (dlg.getOkHit()) {
            CloneTableCommand cmd = new CloneTableCommand(this.tableToClone, this.diagram, newName);
            cmd.actionPerformed(null);
        } else {
            this.setCommandChain(null);
        }
    }

    @Override
    protected void undo() {
    }

    @Override
    protected void setProps() {
        String display = DISPLAY;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.TABLE);
        this.putValue("MnemonicKey", new Integer(67));
    }

    @Override
    public Command duplicate() {
        PromptCloneTable cmdNew = new PromptCloneTable(this.tableToClone, this.diagram);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }
}

