/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.props;

import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchgui.diagram.DiagramEditPanel;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.xml.DiagramProps;

public class UpdateDiagramSettings
extends Command {
    private Diagram diagram_;
    private RenderConfig newRc_;
    private DiagramProps newProps_;
    private RenderConfig oldRc_;
    private DiagramProps oldProps_;
    private String cmdName_;

    public UpdateDiagramSettings(Diagram diagram) {
        this.init(diagram, diagram.getRenderConfig(), diagram.getDiagramProps(), null, null);
        this.buildObject();
    }

    private UpdateDiagramSettings(Diagram diagram, RenderConfig oldRc, DiagramProps oldProps, RenderConfig newRc, DiagramProps newProps) {
        this.init(diagram, oldRc, oldProps, newRc, newProps);
    }

    private void init(Diagram diagram, RenderConfig oldRc, DiagramProps oldProps, RenderConfig newRc, DiagramProps newProps) {
        this.diagram_ = diagram;
        this.newRc_ = newRc;
        this.newProps_ = newProps;
        this.oldRc_ = oldRc;
        this.oldProps_ = oldProps;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName_ = "Update Diagram Setting: " + this.diagram_.getName();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == UpdateDiagramSettings.getStateDo()) {
            this.showDlg();
        } else if (this.getState() == UpdateDiagramSettings.getStateRedo()) {
            this.diagram_.setRenderConfig(this.newRc_);
            this.diagram_.setDiagramProps(this.newProps_);
        }
    }

    private void showDlg() {
        String oldNm = this.diagram_.getName();
        Database db = LookupUtil.getLookupDb();
        DiagramEditPanel editor = DiagramEditPanel.getInstance();
        editor.setItems(this.diagram_, db);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editor);
        editor.setSyncOnEdit(true);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            boolean isRename;
            String newNm = editor.getDiagramAsIs().getName();
            boolean bl = isRename = !oldNm.equals(newNm);
            if (!isRename) {
                this.newRc_ = this.diagram_.getRenderConfig();
                this.newProps_ = this.diagram_.getDiagramProps();
                this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
            }
        } else {
            this.setCommandChain(null);
        }
    }

    @Override
    protected void undo() {
        this.diagram_.setRenderConfig(this.oldRc_);
        this.diagram_.setDiagramProps(this.oldProps_);
    }

    @Override
    public Command duplicate() {
        UpdateDiagramSettings cmdNew = new UpdateDiagramSettings(this.diagram_, this.oldRc_, this.oldProps_, this.newRc_, this.newProps_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", "Diagram Properties");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.PROPS);
        this.putValue("MnemonicKey", new Integer(80));
    }
}

