/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.glyph;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.element.IQualifiedNm;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.idf.AddToCollector;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import com.harrand.sketch.panel.NoteEditPanel;
import com.harrand.sketch.panel.ZoneEditPanel;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public final class AddDiagramIdfCmd
extends Command {
    private Diagram diagram_;
    private String name_;
    private Identifiable addedIdf_ = null;
    private Point origin_ = new Point(0, 0);
    private String mapNm_;

    public AddDiagramIdfCmd(Diagram diagram, String mapNm) {
        this(diagram, null, Command.getStateDo());
        this.mapNm_ = mapNm;
        this.init();
    }

    private AddDiagramIdfCmd(Diagram diagram, Identifiable idf, int state) {
        this.diagram_ = diagram;
        this.addedIdf_ = idf;
        if (idf != null) {
            this.mapNm_ = idf.getMapName();
        }
        this.setState(state);
        this.init();
    }

    private void init() {
        String displayNm = this.diagram_.getDisplayName(this.mapNm_);
        this.name_ = "Add " + displayNm;
        this.setProps();
    }

    public void setOrigin(Point pt) {
        this.origin_ = pt;
    }

    @Override
    public Command duplicate() {
        AddDiagramIdfCmd cmdNew = new AddDiagramIdfCmd(this.diagram_, this.addedIdf_, AddDiagramIdfCmd.getStateUndo());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        DataEditor dataEditor = this.getDataEditor();
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, dataEditor);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            Identifiable idf = dataEditor.getDataObject();
            this.addIdf(idf);
            String glyphNm = idf instanceof IQualifiedNm ? ((IQualifiedNm)((Object)idf)).getQN() : idf.getName();
            this.diagram_.setSelectedGlyph(glyphNm);
        }
    }

    private void addIdf(Identifiable idf) {
        AddToCollector addCommand = new AddToCollector(this.diagram_, idf);
        addCommand.setCommandChain(CommandChainMgr.getCmdChain());
        addCommand.actionPerformed(null);
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", this.getIcon());
        this.putValue("MnemonicKey", new Integer(78));
    }

    @Override
    protected void undo() {
    }

    private DataEditor getDataEditor() {
        JPanel editor = null;
        if (this.mapNm_.equals(Note.getClassName())) {
            editor = new NoteEditPanel(null, this.diagram_);
            editor.setOrigin(this.origin_);
        } else if (this.mapNm_.equals(Zone.getClassName())) {
            editor = new ZoneEditPanel(null, this.diagram_);
            ((ZoneEditPanel)editor).setOrigin(this.origin_);
        }
        return editor;
    }

    private ImageIcon getIcon() {
        ImageIcon icon = Icons.NOTE;
        if (this.mapNm_ != null && this.mapNm_.equals(Zone.getClassName())) {
            icon = Icons.ZONE;
        }
        return icon;
    }
}

