/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.column;

import com.harrand.coregui.EditDialog;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.text.TextEditPanel;
import com.harrand.dbwrench.jdbc.validators.DataTypeLengthValidator;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.Validator;

public class PromptDataTypeLength
extends Command {
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private String cmdName;

    public PromptDataTypeLength(Column column) {
        this.init(column, null);
        this.buildObject();
    }

    private PromptDataTypeLength(Column oldColumn, Column newColumn) {
        this.init(oldColumn, newColumn);
    }

    private void init(Column oldColumn, Column newColumn) {
        this.oldColumn = oldColumn;
        this.newColumn = newColumn;
        this.table = oldColumn.getTable();
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName = "Update Data Type Length on: " + this.oldColumn.getName();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == PromptDataTypeLength.getStateDo()) {
            this.showDlg();
        } else if (this.getState() == PromptDataTypeLength.getStateRedo()) {
            this.doForward();
        }
    }

    private void showDlg() {
        TextEditPanel editor = new TextEditPanel("Data Type Length", "Length:", this.oldColumn.getLengthStr());
        DataTypeLengthValidator inputValidator = new DataTypeLengthValidator();
        inputValidator.setDataType(this.oldColumn.getDataType());
        editor.setInputValidator(inputValidator);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editor);
        editor.setSyncOnEdit(false);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
            String text = editor.getText();
            Integer newLength = Validator.isStringValid(text) ? new Integer(text) : null;
            this.newColumn = (Column)this.oldColumn.getDup();
            this.newColumn.setLength(newLength);
            this.doForward();
        } else {
            this.setCommandChain(null);
        }
    }

    public void doForward() {
        this.table.updateItem(this.oldColumn, this.newColumn);
    }

    @Override
    protected void undo() {
        this.table.updateItem(this.newColumn, this.oldColumn);
    }

    @Override
    public Command duplicate() {
        PromptDataTypeLength cmdNew = new PromptDataTypeLength(this.oldColumn, this.newColumn);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", "Data Type Length");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }
}

