/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.column;

import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.panel.subpanel.DataTypePanel;

public class PromptDataType
extends Command {
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private String cmdName_;

    public PromptDataType(Column column) {
        this.init(column, null);
        this.buildObject();
    }

    private PromptDataType(Column oldColumn, Column newColumn) {
        this.init(oldColumn, newColumn);
    }

    private void init(Column oldColumn, Column newColumn) {
        this.oldColumn = oldColumn;
        this.newColumn = newColumn;
        this.table = oldColumn.getTable();
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName_ = "Update Data Type Values For Column: " + this.oldColumn.getName();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == PromptDataType.getStateDo()) {
            this.showDlg();
        } else if (this.getState() == PromptDataType.getStateRedo()) {
            this.doForward();
        }
    }

    private void showDlg() {
        DataTypePanel editor = new DataTypePanel(this.oldColumn);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editor);
        editor.setSyncOnEdit(false);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
            this.newColumn = (Column)this.oldColumn.getDup();
            this.newColumn.setDataType(editor.getDataType());
            this.newColumn.setLength(editor.getLength());
            this.newColumn.setScale(editor.getScale());
            this.newColumn.setSigned(editor.getSigned());
            this.doForward();
        } else {
            this.setCommandChain(null);
        }
    }

    public void doForward() {
        this.table.updateItem(this.oldColumn, this.newColumn);
    }

    @Override
    protected void undo() {
        this.table.updateItem(this.newColumn, this.oldColumn);
    }

    @Override
    public Command duplicate() {
        PromptDataType cmdNew = new PromptDataType(this.oldColumn, this.newColumn);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", "Data Type Values");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.PROPS);
        this.putValue("MnemonicKey", new Integer(80));
    }
}

