/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.column;

import com.harrand.coregui.EditDialog;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.text.TextEditPanel;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;

public class PromptColumnDefault
extends Command {
    private Table table;
    private Column oldColumn;
    private Column newColumn;
    private String cmdName;

    public PromptColumnDefault(Column column) {
        this.init(column, null);
        this.buildObject();
    }

    private PromptColumnDefault(Column oldColumn, Column newColumn) {
        this.init(oldColumn, newColumn);
    }

    private void init(Column oldColumn, Column newColumn) {
        this.oldColumn = oldColumn;
        this.newColumn = newColumn;
        this.table = oldColumn.getTable();
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName = "Update default on: " + this.oldColumn.getName();
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == PromptColumnDefault.getStateDo()) {
            this.showDlg();
        } else if (this.getState() == PromptColumnDefault.getStateRedo()) {
            this.doForward();
        }
    }

    private void showDlg() {
        TextEditPanel editor = new TextEditPanel("Column Default", "Default:", this.oldColumn.getDefault());
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editor);
        editor.setSyncOnEdit(false);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
            String text = editor.getText();
            this.newColumn = (Column)this.oldColumn.getDup();
            this.newColumn.setDefaultValue(text);
            this.doForward();
        } else {
            this.setCommandChain(null);
        }
    }

    public void doForward() {
        this.table.updateItem(this.oldColumn, this.newColumn);
    }

    @Override
    protected void undo() {
        this.table.updateItem(this.newColumn, this.oldColumn);
    }

    @Override
    public Command duplicate() {
        PromptColumnDefault cmdNew = new PromptColumnDefault(this.oldColumn, this.newColumn);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", "Column Default");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }
}

