/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.column;

import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.panel.ColumnEditPanel;

public class PromptAddPositionedColumn
extends Command {
    private Table table;
    private int colInsertPos;
    private Column newColumn;
    private String cmdName_;

    public PromptAddPositionedColumn(Table table, int colInsertPos) {
        this.init(table, colInsertPos, null);
        this.buildObject();
    }

    private PromptAddPositionedColumn(Table table, int colInsertPos, Column newColumn) {
        this.init(table, colInsertPos, newColumn);
    }

    private void init(Table table, int colInsertPos, Column newColumn) {
        this.table = table;
        this.colInsertPos = colInsertPos;
        this.newColumn = newColumn;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName_ = "Prompt Add Positioned Column";
        this.setProps();
    }

    @Override
    protected void execute() {
        if (this.getState() == PromptAddPositionedColumn.getStateDo()) {
            this.showDlg();
        } else if (this.getState() == PromptAddPositionedColumn.getStateRedo()) {
            this.doForward();
        }
    }

    private void showDlg() {
        ColumnEditPanel editor = new ColumnEditPanel(null, this.table);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editor);
        editor.setSyncOnEdit(false);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
            this.newColumn = editor.getColumn();
            this.doForward();
        } else {
            this.setCommandChain(null);
        }
    }

    public void doForward() {
        this.table.add(this.newColumn);
        this.table.setColumnPosition(this.newColumn, this.colInsertPos);
    }

    @Override
    protected void undo() {
        this.table.remove(Column.getClassName(), this.newColumn.getName());
    }

    @Override
    public Command duplicate() {
        PromptAddPositionedColumn cmdNew = new PromptAddPositionedColumn(this.table, this.colInsertPos, this.newColumn);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", "Data Type Values");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.PROPS);
        this.putValue("MnemonicKey", new Integer(80));
    }
}

