/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command.bldr;

import com.harrand.coreclasses.dataEntry.CompareResult;
import com.harrand.coreclasses.element.ICollPair;
import com.harrand.coreclasses.element.IIdfPair;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.SetProperty;
import com.harrand.coregui.command.idf.AddToCollector;
import com.harrand.coregui.command.idf.RemoveFromCollector;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.element.ITableObj;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.command.PromptRemoveTableCmd;
import com.harrand.dbwrenchgui.command.UpdateSchProps;
import com.harrand.dbwrenchgui.command.UpdateTblProps;
import java.util.HashMap;
import java.util.Map;

public class RevSyncCmdBldr {
    private Map tblsToAdd_ = new HashMap();

    public void clearTblsToAdd() {
        this.tblsToAdd_ = new HashMap();
    }

    public Map getTblsToAdd() {
        return this.tblsToAdd_;
    }

    public Command getCmd(CompareResult compareResult) {
        IIdfPair idfPair = compareResult.getIdfPair();
        ICollPair collPair = compareResult.getCollPair();
        Identifiable svrIdf = idfPair.getSvrIdf();
        Identifiable designIdf = idfPair.getDesignIdf();
        Collector designColl = collPair.getDesignColl();
        String idfClz = idfPair.getClz();
        String collClz = collPair.getClz();
        if (idfClz.equals(PrimaryKey.getClassName())) {
            return this.getPkCmd(svrIdf, designIdf, designColl);
        }
        if (idfClz.equals(ForeignKey.getClassName())) {
            return this.getFkCmd(svrIdf, designIdf, designColl);
        }
        if (idfClz.equals(Column.getClassName())) {
            return this.getColumnCmd(svrIdf, designIdf, designColl);
        }
        if (idfClz.equals(Table.getClassName())) {
            return this.getTblCmd(svrIdf, designIdf, designColl);
        }
        if (idfClz.equals(Schema.getClassName())) {
            return this.getSchCmd(svrIdf, designIdf, designColl);
        }
        if (collClz.equals(Schema.getClassName())) {
            return this.getSchemaObjCmd(svrIdf, designIdf, designColl);
        }
        if (collClz.equals(Table.getClassName())) {
            return this.getTableObjCmd(svrIdf, designIdf, designColl);
        }
        Command cmd = null;
        cmd = idfPair.getHasNull() ? (svrIdf == null ? this.getRemoveCmd(designIdf, designColl) : this.getAddCmd(svrIdf, designColl)) : this.getUpdateCmd(svrIdf, designIdf, designColl);
        return cmd;
    }

    private Command getUpdateCmd(Identifiable svrIdf, Identifiable designIdf, Collector designColl) {
        UpdateInCollector cmd = new UpdateInCollector(designColl, designIdf, svrIdf);
        return cmd;
    }

    private Command getAddCmd(Identifiable svrIdf, Collector designColl) {
        AddToCollector cmd = new AddToCollector(designColl, svrIdf);
        return cmd;
    }

    private Command getRemoveCmd(Identifiable designIdf, Collector designColl) {
        RemoveFromCollector cmd = new RemoveFromCollector(designColl, designIdf.getMapName(), designIdf.getName());
        return cmd;
    }

    private Command getPkCmd(Identifiable svrIdf, Identifiable designIdf, Collector designColl) {
        Table tbl = (Table)designColl;
        PrimaryKey svrPk = (PrimaryKey)svrIdf;
        PrimaryKey designPk = (PrimaryKey)designIdf;
        return new SetProperty(tbl, designPk, svrPk);
    }

    private Command getFkCmd(Identifiable svrIdf, Identifiable designIdf, Collector designColl) {
        if (svrIdf != null) {
            ForeignKey fkSvr = (ForeignKey)svrIdf;
            ForeignKey fkDesign = (ForeignKey)designIdf;
            Table designChdTbl = (Table)designColl;
            String svrParTblDn = fkSvr.getParTbl().getDotNote();
            Database designDb = designChdTbl.getSchema().getDb();
            Table parTblDesign = designDb.containsTable(svrParTblDn) ? designDb.getTableFromDotNote(svrParTblDn) : (Table)this.tblsToAdd_.get(svrParTblDn.toLowerCase());
            ForeignKey dupSvrfk = fkSvr.getDupUseTables(parTblDesign, (Table)designColl);
            if (designIdf != null) {
                return new UpdateInCollector(designColl, designIdf, dupSvrfk);
            }
            return new AddToCollector(designColl, dupSvrfk);
        }
        return new RemoveFromCollector(designColl, designIdf.getMapName(), designIdf.getName());
    }

    private Command getTblCmd(Identifiable svrIdf, Identifiable designIdf, Collector designColl) {
        if (svrIdf != null) {
            Table svrTbl = (Table)svrIdf;
            Table designTbl = (Table)designIdf;
            if (designIdf != null) {
                String designTblNm;
                String svrTblNm = svrIdf.getName();
                if (!svrTblNm.equalsIgnoreCase(designTblNm = designIdf.getName())) {
                    RenameIdf rnmCmd = new RenameIdf(designColl, designIdf, designTblNm, svrTblNm, App.getCommandChain());
                    Database db = designTbl.getSchema().getDb();
                    rnmCmd.setRenameMgr(db.getRenameMgr());
                    return rnmCmd;
                }
                return new UpdateTblProps(designTbl, svrTbl.getComment(), svrTbl.getTableOptions());
            }
            Table dupSvrTbl = svrTbl.getShallowClone();
            this.tblsToAdd_.put(dupSvrTbl.getDotNote().toLowerCase(), dupSvrTbl);
            return new AddToCollector(designColl, dupSvrTbl);
        }
        Table designTbl = (Table)designIdf;
        Database designDb = designTbl.getSchema().getDb();
        PromptRemoveTableCmd cmd = new PromptRemoveTableCmd(designDb);
        cmd.setIdfDotNote(designTbl.getDotNote());
        cmd.setShowWarning(false);
        return cmd;
    }

    private Command getSchCmd(Identifiable svrIdf, Identifiable designIdf, Collector designColl) {
        if (svrIdf != null) {
            Schema svrSch = (Schema)svrIdf;
            Schema designSch = (Schema)designIdf;
            if (designIdf != null) {
                return new UpdateSchProps(designSch, designSch.getComment(), svrSch.getComment());
            }
            return new AddToCollector(designColl, svrSch);
        }
        return new RemoveFromCollector(designColl, designIdf.getMapName(), designIdf.getName());
    }

    private Command getSchemaObjCmd(Identifiable svrIdf, Identifiable designIdf, Collector designColl) {
        if (svrIdf != null) {
            ISchemaObj schemaObj = (ISchemaObj)((Object)svrIdf);
            ISchemaObj dupSvrObj = schemaObj.getDupSchemaNull();
            Identifiable dupSvrIdf = (Identifiable)((Object)dupSvrObj);
            if (designIdf != null) {
                return new UpdateInCollector(designColl, designIdf, dupSvrIdf);
            }
            return new AddToCollector(designColl, dupSvrIdf);
        }
        return new RemoveFromCollector(designColl, designIdf.getMapName(), designIdf.getName());
    }

    private Command getColumnCmd(Identifiable svrIdf, Identifiable designIdf, Collector designColl) {
        String designIdfNm;
        String svrIdfNm;
        Command cmd = null;
        if (svrIdf != null && designIdf != null && !(svrIdfNm = svrIdf.getName()).equalsIgnoreCase(designIdfNm = designIdf.getName())) {
            Database db = ((Table)designColl).getSchema().getDb();
            cmd = new RenameIdf(designColl, designIdf, designIdfNm, svrIdfNm, App.getCommandChain());
            ((RenameIdf)cmd).setRenameMgr(db.getRenameMgr());
        }
        if (cmd == null) {
            cmd = this.getTableObjCmd(svrIdf, designIdf, designColl);
        }
        return cmd;
    }

    private Command getTableObjCmd(Identifiable svrIdf, Identifiable designIdf, Collector designColl) {
        if (svrIdf != null) {
            ITableObj TableObj = (ITableObj)((Object)svrIdf);
            ITableObj dupSvrObj = TableObj.getDup();
            Identifiable dupSvrIdf = (Identifiable)((Object)dupSvrObj);
            if (designIdf != null) {
                return new UpdateInCollector(designColl, designIdf, dupSvrIdf);
            }
            return new AddToCollector(designColl, dupSvrIdf);
        }
        return new RemoveFromCollector(designColl, designIdf.getMapName(), designIdf.getName());
    }
}

