/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.option.BooleanOption;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.dataEntry.IFocusable;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.command.AddFkFromPk;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.initializer.SingleLinkPositionInitializer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class QuickFkPanel
extends JPanel
implements ITitled,
ISized,
IFocusable,
KeyListener,
ISizeStorable {
    private DbUser user_ = null;
    private final Database db_;
    private final Diagram diagram_;
    private final Table chdTbl_;
    private DefaultListModel listModel_;
    private JDialog parentDlg_;
    private final int chdFkCount_;
    private final IOptionMgr diagramOptMgr_;
    private XpHeaderPanel headerPanel_;
    private final JTextPane txtHelp_ = new JTextPane();
    private JList lstTables_ = new JList();
    private final JLabel lblTables_ = GuiHelper.getTitleLabel("Parent Table");
    private JCheckBox chkOnlyDiaTbls_;
    private ActionListener lisOk_;
    private static final ISizeStorable basicSizeStorable__ = new BasicSizeStorable(new Dimension(560, 425));

    public QuickFkPanel(DbUser user, Database db, Diagram diagram, Table chdTbl) {
        this.user_ = user;
        this.db_ = db;
        this.diagram_ = diagram;
        this.chdTbl_ = chdTbl;
        this.diagramOptMgr_ = this.user_.getOptionMgr("diagram.option.mgr");
        this.chdFkCount_ = this.chdTbl_.size(ForeignKey.getClassName());
        this.setupGui();
    }

    public ActionListener getOkListener() {
        return this.lisOk_;
    }

    public int getListItemCount() {
        return this.lstTables_.getModel().getSize();
    }

    public void setParentDlg(JDialog parentDlg) {
        this.parentDlg_ = parentDlg;
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        this.headerPanel_ = new XpHeaderPanel(this.getTitle(), "Select a parent table from which to add the foreign key");
        BooleanOption filterOpt = (BooleanOption)this.diagramOptMgr_.getOption(BooleanOption.clazz(), "diagram.quick.fk.dia.tbls.only");
        boolean filterValue = filterOpt.getValue();
        String filterStr = filterOpt.getLabel();
        this.chkOnlyDiaTbls_ = new JCheckBox(filterStr, filterValue);
        this.listModel_ = new DefaultListModel();
        this.lstTables_ = new JList(this.listModel_);
        this.updateListDisplay();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.headerPanel_, "North");
        this.add((Component)this.getBodyPanel(), "Center");
    }

    private JPanel getBodyPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)this.getListPanel(), "Center");
        if (this.isDiagramSet()) {
            panel.add((Component)this.getCheckBoxPanel(), "South");
        }
        GuiHelper.addBodyPanelBorder(panel);
        return panel;
    }

    private JPanel getListPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 2));
        panel.add((Component)this.lblTables_, "North");
        panel.add((Component)new JScrollPane(this.lstTables_), "Center");
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getCheckBoxPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createHorizontalStrut(8));
        panel.add(this.chkOnlyDiaTbls_);
        return panel;
    }

    private void addListeners() {
        ActionListener lisFilter = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QuickFkPanel.this.updateListDisplay();
                QuickFkPanel.this.diagramOptMgr_.setBoolValue("diagram.quick.fk.dia.tbls.only", QuickFkPanel.this.chkOnlyDiaTbls_.isSelected());
            }
        };
        this.chkOnlyDiaTbls_.addActionListener(lisFilter);
        this.lisOk_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (QuickFkPanel.this.checkSelected(true)) {
                    QuickFkPanel.this.addQuickFk();
                }
            }
        };
        MouseAdapter mouseLis = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = QuickFkPanel.this.lstTables_.locationToIndex(e.getPoint())) >= 0) {
                    QuickFkPanel.this.addQuickFk();
                }
            }
        };
        this.lstTables_.addMouseListener(mouseLis);
        this.lstTables_.addKeyListener(this);
    }

    private void setNames() {
        this.lstTables_.setName("lstTables");
        this.chkOnlyDiaTbls_.setName("chkOnlyDiaTbls");
    }

    private void setCosmetics() {
        this.txtHelp_.setBackground(this.getBackground());
        this.txtHelp_.setForeground(Color.BLACK);
        this.txtHelp_.setEditable(false);
        this.lstTables_.setSelectionMode(0);
        this.chkOnlyDiaTbls_.setMnemonic('d');
    }

    private void updateListDisplay() {
        this.listModel_.clear();
        Iterator it = this.getTableNms().iterator();
        while (it.hasNext()) {
            this.listModel_.addElement(it.next());
        }
    }

    private boolean checkSelected(boolean warn) {
        boolean selected = false;
        int selIdx = this.lstTables_.getSelectedIndex();
        if (selIdx >= 0) {
            selected = true;
        }
        if (warn && !selected) {
            GuiMessageHelper.showInputErrMsg(null, "Invalid Selection", "A parent table must be selected.");
        }
        return selected;
    }

    private void addQuickFk() {
        if (this.checkSelected(false)) {
            String strBracket = (String)this.lstTables_.getSelectedValue();
            Table parTbl = this.db_.getTableFromSchemaBracket(strBracket);
            CommandChain cmdChain = CommandChainMgr.getInstance().getCommandChain();
            AddFkFromPk cmd = new AddFkFromPk(this.db_, this.chdTbl_, parTbl, cmdChain);
            cmd.actionPerformed(null);
            if (this.checkFkAdded()) {
                this.checkInitalizeLink(parTbl, this.chdTbl_);
                this.closeParentDlg();
            }
        }
    }

    private void checkInitalizeLink(Table parentTable, Table childTable) {
        new SingleLinkPositionInitializer().initializeLinkPosition(this.db_, parentTable, childTable);
    }

    private void closeParentDlg() {
        if (this.parentDlg_ != null) {
            this.parentDlg_.setVisible(false);
            this.parentDlg_.dispose();
        }
    }

    private boolean checkFkAdded() {
        int currentFkCount = this.chdTbl_.size(ForeignKey.getClassName());
        return currentFkCount > this.chdFkCount_;
    }

    private List getTableNms() {
        boolean useDiagramOnlyNms = this.chkOnlyDiaTbls_.isSelected() && this.isDiagramSet();
        List tblNms = useDiagramOnlyNms ? this.getDiagramOnlyTblNms() : this.getAllTblNms();
        return tblNms;
    }

    private List getDiagramOnlyTblNms() {
        ArrayList<String> nms = new ArrayList<String>();
        for (Glyph obj : this.diagram_.getOnlyGlyphs()) {
            if (!(obj instanceof DbTableGlyph)) continue;
            DbTableGlyph glyph = (DbTableGlyph)obj;
            nms.add(glyph.getTable().getSchemaBracket());
        }
        Collections.sort(nms, String.CASE_INSENSITIVE_ORDER);
        return nms;
    }

    private List getAllTblNms() {
        List nms = this.db_.getAllTableNmsOptionBrackets();
        return nms;
    }

    private boolean isDiagramSet() {
        return this.diagram_ != null;
    }

    @Override
    public void transferFocus() {
        this.lstTables_.requestFocus();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(basicSizeStorable__.getSize());
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.FK_ADD;
    }

    @Override
    public String getTitle() {
        return "Add Quick Foreign Key";
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public Dimension getSize() {
        return basicSizeStorable__.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        basicSizeStorable__.setSize(size);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.lstTables_.ensureIndexIsVisible(this.lstTables_.getSelectedIndex());
    }
}

