/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coregui.EditDialog;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.panel.SchemaEditPanel;
import java.awt.event.ActionEvent;

public class PromptSchemaUpdate
extends Command {
    private Database db_;
    private Schema schema_;
    private String cmdName_;

    public PromptSchemaUpdate(Schema schema) {
        this.db_ = schema.getDb();
        this.schema_ = schema;
        this.buildObject();
    }

    private void buildObject() {
        this.cmdName_ = "Update Schema: " + this.schema_.getName();
        this.setProps();
    }

    @Override
    protected void execute() {
        SchemaEditPanel panel = new SchemaEditPanel(this.schema_);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, panel, panel.getPreferredBounds(), panel.getTitle());
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            Schema schShallow = panel.getSchema();
            String newName = schShallow.getName();
            String newComment = schShallow.getComment();
            String oldNm = this.schema_.getName();
            String oldCmm = this.schema_.getComment();
            if (!oldNm.equals(newName)) {
                RenameIdf cmdRnm = new RenameIdf(this.db_, this.schema_, oldNm, newName, App.getCommandChain());
                cmdRnm.setRenameMgr(this.db_.getRenameMgr());
                cmdRnm.actionPerformed(new ActionEvent(this, 0, ""));
            }
            if (!oldCmm.equals(newComment)) {
                this.schema_.setComment(newComment);
            }
        }
    }

    @Override
    protected void undo() {
    }

    @Override
    public Command duplicate() {
        PromptSchemaUpdate cmdNew = new PromptSchemaUpdate(this.schema_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + "Edit";
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", new Integer(69));
    }
}

