/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.idf.ISpecificIdfRemoveCmd;
import com.harrand.coregui.command.idf.RemoveTableCmd;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import java.util.List;
import java.util.Map;

public class PromptRemoveTableCmd
extends Command
implements ISpecificIdfRemoveCmd {
    private Database db_;
    private Table table_;
    private Schema schema_;
    private String cmdName_;
    private Map removedDiagramGlyphsMap_ = null;
    private List removedFks_ = null;
    private boolean showWarning_ = true;

    public PromptRemoveTableCmd(Database db) {
        this.db_ = db;
    }

    private PromptRemoveTableCmd(Database db, Table table, Map removedDiagramGlyphsMap, List removedFks, boolean showWarning) {
        this(db);
        this.table_ = table;
        this.schema_ = this.table_.getSchema();
        this.removedDiagramGlyphsMap_ = removedDiagramGlyphsMap;
        this.removedFks_ = removedFks;
        this.setShowWarning(showWarning);
        this.buildObject();
    }

    @Override
    public void setIdfDotNote(String dotNote) {
        this.table_ = this.db_.getTableFromDotNote(dotNote);
        this.schema_ = this.table_.getSchema();
        this.buildObject();
    }

    public String getIdfName() {
        if (this.table_ != null) {
            return this.table_.getName();
        }
        return "RemoveTableCmd.err: IdfName is not set.";
    }

    @Override
    public final void setShowWarning(boolean show) {
        this.showWarning_ = show;
    }

    @Override
    public boolean getShowWarning() {
        return this.showWarning_;
    }

    private void buildObject() {
        this.cmdName_ = "Remove Table";
        this.setProps();
    }

    @Override
    public Command duplicate() {
        PromptRemoveTableCmd cmdNew = new PromptRemoveTableCmd(this.db_, this.table_, this.removedDiagramGlyphsMap_, this.removedFks_, this.getShowWarning());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        if (this.table_ == null) {
            LogUtil.logErr("RemoveTableCmd.err: idfName not set.");
            return;
        }
        boolean yesHit = true;
        if (this.getShowWarning()) {
            yesHit = GuiMessageHelper.showYesNoMsg(null, "Confirm - Remove Table", "Removing a table will remove related foreign keys and diagram table glyphs. Continue?");
        }
        if (!yesHit) {
            return;
        }
        RemoveTableCmd removeCmd = new RemoveTableCmd(this.db_, this.table_);
        removeCmd.actionPerformed(null);
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", 82);
    }

    @Override
    protected void undo() {
    }
}

