/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.command;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrench.template.ColumnTemplateSvr;
import com.harrand.dbwrenchgui.panel.TableAddPanel;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.util.LogUtil;
import java.awt.Point;

public final class AddNewTableGlyph
extends Command {
    private String name_;
    private Database db_;
    private DbUser user_;
    private ColumnTemplateSvr templateSrv_;
    private IOptionMgr dbOptMgr_;
    private Point p_;
    private Schema sch_;
    private String tblNm_;
    private Table table_;
    private Glyph glyph_;
    private Diagram diagram_;
    private String mapName_ = Table.getClassName();

    public AddNewTableGlyph(Database db, Schema sch, DbUser user, Diagram diagram, Point p) {
        this(db, user, diagram, p, sch, null, Command.getStateDo());
    }

    private AddNewTableGlyph(Database db, DbUser user, Diagram diagram, Point p, Schema sch, String tableName, int state) {
        this.db_ = db;
        this.user_ = user;
        this.diagram_ = diagram;
        this.p_ = p;
        this.tblNm_ = tableName;
        this.sch_ = sch;
        this.name_ = App.getRes("add.new.table.label");
        this.setState(state);
        this.setProps();
        this.setCommandChain(CommandChainMgr.getCmdChain());
    }

    private void setTable(Table tbl) {
        this.table_ = tbl;
    }

    private void setGlyph(Glyph glyph) {
        this.glyph_ = glyph;
    }

    @Override
    public Command duplicate() {
        AddNewTableGlyph cmdNew = new AddNewTableGlyph(this.db_, this.user_, this.diagram_, this.p_, this.sch_, this.tblNm_, AddNewTableGlyph.getStateDo());
        cmdNew.setTable(this.table_);
        cmdNew.setGlyph(this.glyph_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        if (this.table_ != null) {
            this.readdTable();
        } else {
            this.promptAddTable();
        }
    }

    private void readdTable() {
        this.sch_.add(this.table_);
        ITestResult rslt = this.diagram_.addGlyph(this.glyph_);
        if (rslt.getPassed()) {
            this.diagram_.setSelectedGlyph(this.glyph_.getName());
        } else {
            GuiMessageHelper.showInputErrMsg(null, rslt);
        }
    }

    private void promptAddTable() {
        TableAddPanel dataEditor = new TableAddPanel(this.sch_, this.user_, this.db_);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, dataEditor);
        dataEditor.setParentDialog(dlg);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            this.table_ = (Table)dataEditor.getDataObject();
            this.tblNm_ = this.table_.getName();
            Schema schOut = dataEditor.getSchema();
            schOut.add(this.table_);
            this.sch_ = schOut;
            Point zoomedPt = this.diagram_.getDiagramPt(this.p_);
            this.glyph_ = new DbTableGlyph(zoomedPt, this.table_, this.diagram_);
            this.diagram_.addGlyph(this.glyph_);
            this.diagram_.setSelectedGlyph(this.glyph_.getName());
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.ADD);
        this.putValue("MnemonicKey", new Integer(84));
    }

    @Override
    protected void undo() {
        if (this.tblNm_ != null) {
            try {
                Table removeTbl = this.sch_.getTable(this.tblNm_);
                this.sch_.remove(this.mapName_, removeTbl.getName());
                this.diagram_.removeGlyph(removeTbl.getDotNote());
            }
            catch (Exception e) {
                e.printStackTrace();
                GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
            }
        } else {
            LogUtil.logMsg("AddNewTableGlyph.undo: Tried undo for null tbl: " + this.sch_.getName() + "." + this.tblNm_);
        }
    }
}

