/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml.converter;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.option.UserOptionMgr;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.sketch.core.RenderConfig;
import java.awt.Font;
import java.awt.Point;
import java.util.List;

public class FontConvPre132 {
    public void convert(RenderConfig rc, List glyphs, String diagramNm) {
        Zoom oldZoom = rc.getZoom();
        if (this.needsConversion(oldZoom)) {
            System.out.println("Converting diagram font for: " + diagramNm + "...");
            double oldZoomLevel = oldZoom.getLevel();
            int newFontSize = (int)(oldZoomLevel * 10.0) + 1;
            Font oldFont = rc.getFont();
            Font newFont = new Font(oldFont.getFamily(), 0, newFontSize);
            rc.setFont(newFont);
            rc.set(new Zoom(1.0));
            for (Object obj : glyphs) {
                if (!(obj instanceof DbTableGlyph)) continue;
                DbTableGlyph glyph = (DbTableGlyph)obj;
                Point oldStart = glyph.getStart();
                Point newStart = Zoomer.zoom(oldStart, oldZoomLevel);
                glyph.move(newStart);
            }
            DbUser user = App.getUser();
            if (user != null) {
                UserOptionMgr optMgr = (UserOptionMgr)user.getOptionMgr("diagram.option.mgr");
                optMgr.setIntValue("diagram.default.font.size", newFont.getSize());
            }
        }
    }

    private boolean needsConversion(Zoom oldZoom) {
        boolean needsConv = false;
        double oldLevel = oldZoom.getLevel();
        if (oldLevel >= 0.7 && oldLevel < 1.0) {
            needsConv = true;
        }
        return needsConv;
    }
}

