/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SeqXmlCtrl
implements IXmlCtrl {
    public static final String SEQ = "Seq";
    public static final String INCR = "incr";

    public Element asXmlElement(Document doc, Sequence seq) {
        Element elmSeq = doc.createElement(SEQ);
        elmSeq.setAttribute("nm", seq.getName());
        XmlHelper.setAttr(elmSeq, INCR, seq.getIncrement());
        XmlHelper.addConditionCommentElm(doc, elmSeq, seq.getComment());
        return elmSeq;
    }

    public static Sequence fromXml(Element element) {
        String name = element.getAttribute("nm");
        int incr = XmlHelper.getAttrInt(element, INCR);
        String comment = XmlHelper.getConditionComment(element);
        Sequence newSeq = null;
        try {
            newSeq = new Sequence(name, incr, comment);
        }
        catch (Exception e) {
            LogUtil.logErr("SequenceXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newSeq;
    }
}

