/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.object.Proc;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcXmlCtrl
implements IXmlCtrl {
    public static final String PROC = "Proc";
    public static final String SRC = "src";

    public Element asXmlElement(Document doc, Proc proc) {
        Element elmProc = doc.createElement(PROC);
        elmProc.setAttribute("nm", XmlHelper.removeInvalidXmlChars(proc.getName()));
        XmlHelper.addConditionCommentElm(doc, elmProc, proc.getComment());
        XmlHelper.addElementSimple(doc, elmProc, SRC, XmlHelper.removeInvalidXmlChars(proc.getSrc()));
        return elmProc;
    }

    public static Proc fromXml(Element element) {
        String name = element.getAttribute("nm");
        String src = XmlHelper.getFirstElementValue(element, SRC);
        String comment = XmlHelper.getConditionComment(element);
        Proc newProc = null;
        try {
            newProc = new Proc(src, comment, name);
        }
        catch (Exception e) {
            LogUtil.logErr("ProcXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newProc;
    }
}

