/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.dataEntry.OpenEditorVO;
import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrenchgui.db.query.objects.query.DbQuery;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OpenEditorXmlCtrl
implements IXmlCtrl {
    public static final String OPEN_EDITORS = "OpenEditors";
    public static final String OPEN_EDITOR = "OpenEditor";

    public Element asXmlElement(Document doc, List<OpenEditorVO> editorVOs) {
        Element elmOpenEditors = doc.createElement(OPEN_EDITORS);
        for (OpenEditorVO editorVO : editorVOs) {
            CollectorIdf collIdf = editorVO.getCollectorIdf();
            Identifiable idf = collIdf.getIdentifiable();
            String fqn = collIdf.getFQN();
            Element elmOpenEditor = doc.createElement(OPEN_EDITOR);
            elmOpenEditor.setAttribute("ClsNm", idf.getMapName());
            elmOpenEditor.setAttribute("fqn", fqn);
            XmlHelper.setAttrBoolAsInt(elmOpenEditor, "selected", editorVO.getSelected());
            elmOpenEditors.appendChild(elmOpenEditor);
        }
        return elmOpenEditors;
    }

    public static List<OpenEditorVO> fromXml(Database db, Element element) {
        ArrayList<OpenEditorVO> editorVOs = new ArrayList<OpenEditorVO>();
        if (element == null) {
            return editorVOs;
        }
        NodeList list = element.getElementsByTagName(OPEN_EDITOR);
        for (int i = 0; i < list.getLength(); ++i) {
            String fqn;
            Element elmVO = (Element)list.item(i);
            String clsNm = elmVO.getAttribute("ClsNm");
            CollectorIdf collIdf = OpenEditorXmlCtrl.buildCollIdf(db, clsNm, fqn = elmVO.getAttribute("fqn"));
            if (collIdf == null) continue;
            boolean selected = XmlHelper.getAttrBoolFromInt(elmVO, "selected");
            OpenEditorVO editorVO = new OpenEditorVO(collIdf, selected);
            editorVOs.add(editorVO);
        }
        return editorVOs;
    }

    private static CollectorIdf buildCollIdf(Database db, String clsNm, String fqn) {
        CollectorIdf collIdf = null;
        Schema sch = null;
        String[] parts = fqn.split("\\.");
        if (clsNm.equals(Proc.getClassName())) {
            sch = db.getSchema(parts[0]);
            String procNm = sch.getValidProcNm(parts[1]);
            if (sch.contains(Proc.getClassName(), procNm)) {
                Proc proc = sch.getProc(procNm);
                collIdf = new CollectorIdf(sch, proc);
            }
        } else if (clsNm.equals(Diagram.getClassName())) {
            String diagramNm;
            String string = diagramNm = parts.length > 1 ? parts[1] : parts[0];
            if (db.contains(Diagram.getClassName(), diagramNm)) {
                Diagram diagram = db.getDiagram(diagramNm);
                collIdf = new CollectorIdf(db, diagram);
            }
        } else if (clsNm.equals(DbQuery.getClassName())) {
            String queryNm;
            String string = queryNm = parts.length > 1 ? parts[1] : parts[0];
            if (db.contains(DbQuery.getClassName(), queryNm)) {
                DbQuery query = db.getQuery(queryNm);
                collIdf = new CollectorIdf(db, query);
            }
        } else if (clsNm.equals(View.getClassName())) {
            sch = db.getSchema(parts[0]);
            String vwNm = parts[1];
            if (sch.contains(View.getClassName(), vwNm)) {
                View view = sch.getView(vwNm);
                collIdf = new CollectorIdf(sch, view);
            }
        } else if (clsNm.equals(Trigger.getClassName())) {
            sch = db.getSchema(parts[0]);
            String tblNm = parts[1];
            if (sch.contains(Table.getClassName(), tblNm)) {
                Table tbl = sch.getTable(tblNm);
                String trgNm = parts[2];
                if (tbl.contains(Trigger.getClassName(), trgNm)) {
                    Trigger trg = tbl.getTrigger(trgNm);
                    collIdf = new CollectorIdf(tbl, trg);
                }
            }
        } else {
            LogUtil.logErr("OpenEditorXmlCtrl.could not create. FQN: " + fqn + ", clsNm: " + clsNm);
        }
        return collIdf;
    }

    private boolean containsIdf(Collector coll, String mapNm, String idfNm) {
        return coll.contains(mapNm, idfNm);
    }
}

