/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.ColumnFunction;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IndexXmlCtrl
implements IXmlCtrl {
    public static final String IDX = "Idx";
    public static final String CLUSTERED = "clu";
    public static final String UNIQUE = "unq";
    public static final String COL_NAMES = "ClNs";
    public static final String FULL_TEXT = "ftx";
    public static final String SPATIAL = "spa";
    public static final String OPTION_TEXT = "OptTx";

    public Element asXmlElement(Document doc, Table table, Index index) {
        Element elmIdx = doc.createElement(IDX);
        elmIdx.setAttribute("nm", index.getName());
        XmlHelper.setAttrBoolAsInt(elmIdx, UNIQUE, index.getUnique());
        XmlHelper.setAttrBoolAsInt(elmIdx, FULL_TEXT, index.getFullText());
        XmlHelper.setAttrBoolAsInt(elmIdx, SPATIAL, index.getSpatial());
        XmlHelper.setAttrBoolAsInt(elmIdx, CLUSTERED, index.getClusteredFlag());
        String colTextsCsv = index.getIndexColumnDdlTextsCSV();
        XmlHelper.addElementSimple(doc, elmIdx, COL_NAMES, colTextsCsv);
        XmlHelper.addElementSimple(doc, elmIdx, OPTION_TEXT, index.getOptionText());
        return elmIdx;
    }

    public static Index fromXml(Table table, Element element) {
        String name = element.getAttribute("nm");
        boolean unique = XmlHelper.getAttrBoolFromInt(element, UNIQUE);
        boolean clustered = XmlHelper.getAttrBoolFromInt(element, CLUSTERED);
        boolean spatial = XmlHelper.getAttrBoolFromInt(element, SPATIAL);
        boolean fullText = XmlHelper.getAttrBoolFromInt(element, FULL_TEXT);
        String optionText = XmlHelper.getFirstElementValue(element, OPTION_TEXT);
        String colNameCsv = XmlHelper.getFirstElementValue(element, COL_NAMES);
        ArrayList<String> colNms = new ArrayList<String>(Arrays.asList(colNameCsv.split(", ")));
        ArrayList<IIndexColumn> indexColumns = new ArrayList<IIndexColumn>();
        for (Object e : colNms) {
            String objText = e.toString();
            if (table.hasColumn(objText)) {
                indexColumns.add(table.getColumn(objText));
                continue;
            }
            indexColumns.add(new ColumnFunction(objText));
        }
        Index newIdx = null;
        try {
            newIdx = new Index(name, indexColumns, clustered, unique);
            newIdx.setFullText(fullText);
            newIdx.setSpatial(spatial);
            newIdx.setOptionText(optionText);
        }
        catch (Exception exception) {
            LogUtil.logErr("IndexXmlCtr.fromXml.error: " + exception.getMessage());
        }
        return newIdx;
    }
}

