/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.display.BasicColorable;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.xml.link.PositionableLineXmlCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.OneLineUserLinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.ThreeLineUserLinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.TwoLineUserLinkPositioner;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FkGlyphXmlCtrl
implements IXmlCtrl {
    private PositionableLineXmlCtrl positionableLineXmlCtrl = new PositionableLineXmlCtrl();
    public static final String FK_GLYPH = "FkGl";
    public static final String POSITIONER_NM = "positioner";
    public static final String PARENT_EDGE_NM = "parentEdge";
    public static final String CHILD_EDGE_NM = "childEdge";

    public Element asXmlElement(Document doc, ForeignKeyGlyph fkGlyph) {
        Element elmGlyph = doc.createElement(FK_GLYPH);
        elmGlyph.setAttribute("nm", fkGlyph.getName());
        Color bkColor = fkGlyph.getColor("MainBox");
        elmGlyph.setAttribute("bkCl", Integer.toHexString(bkColor.getRGB()));
        this.setEdgeAttribute(elmGlyph, PARENT_EDGE_NM, fkGlyph.getParentEdge());
        this.setEdgeAttribute(elmGlyph, CHILD_EDGE_NM, fkGlyph.getChildEdge());
        this.setLinkPositioner(elmGlyph, fkGlyph);
        LinkLineExtractor lineExtractor = new LinkLineExtractor();
        List<PositionableLine> lines = lineExtractor.getPositionableLines(fkGlyph);
        Element elmLines = this.positionableLineXmlCtrl.asXmlElement(doc, lines);
        elmGlyph.appendChild(elmLines);
        return elmGlyph;
    }

    public static ForeignKeyGlyph fromXml(Element element, Database db, Diagram diagram) {
        String dotNote = element.getAttribute("nm");
        ForeignKey fk = db.getFkUtil().getFkFromDotNote(dotNote);
        Color bkColor = BasicColorable.fromXmlHexString(element, "bkCl");
        String positionerClassName = element.getAttribute(POSITIONER_NM);
        ILinkPositioner positioner = FkGlyphXmlCtrl.getPositioner(positionerClassName);
        ForeignKeyGlyph fkGlyph = null;
        try {
            fkGlyph = new ForeignKeyGlyph(fk, diagram, bkColor);
            fkGlyph.setBoxes(diagram.getGlyphsList());
            fkGlyph.setParentEdge(FkGlyphXmlCtrl.getEdge(element, PARENT_EDGE_NM));
            fkGlyph.setChildEdge(FkGlyphXmlCtrl.getEdge(element, CHILD_EDGE_NM));
            fkGlyph.setDirtyTracker(db);
            fkGlyph.setLinkPositioner(positioner);
            fkGlyph.setShapes(FkGlyphXmlCtrl.getLines(fkGlyph, element));
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            LogUtil.logErr("FkGlyphXmlCtrl.fromXml.error: " + e.getMessage());
        }
        return fkGlyph;
    }

    private static ILinkPositioner getPositioner(String positionerClassName) {
        if (positionerClassName.equalsIgnoreCase(OneLineUserLinkPositioner.class.getSimpleName())) {
            return new OneLineUserLinkPositioner();
        }
        if (positionerClassName.equalsIgnoreCase(TwoLineUserLinkPositioner.class.getSimpleName())) {
            return new TwoLineUserLinkPositioner();
        }
        if (positionerClassName.equalsIgnoreCase(ThreeLineUserLinkPositioner.class.getSimpleName())) {
            return new ThreeLineUserLinkPositioner();
        }
        return null;
    }

    private static List getLines(Link link, Element elmLink) {
        Element elmLines = XmlHelper.getFirstElementByTagName(elmLink, "positionableLines");
        if (elmLines != null) {
            return PositionableLineXmlCtrl.fromXml(link, elmLines);
        }
        return new ArrayList();
    }

    private void setLinkPositioner(Element elmGlyph, ForeignKeyGlyph fkGlyph) throws DOMException {
        ILinkPositioner linkPositioner = fkGlyph.getLinkPositioner();
        String positionerClassName = linkPositioner != null ? linkPositioner.getClass().getSimpleName() : "";
        elmGlyph.setAttribute(POSITIONER_NM, positionerClassName);
    }

    private void setEdgeAttribute(Element elmGlyph, String edgeAttributeName, Edge edge) {
        String edgeText = edge != null ? edge.toString() : "";
        elmGlyph.setAttribute(edgeAttributeName, edgeText);
    }

    private static Edge getEdge(Element elmGlyph, String edgeAttributeName) {
        String edgeText = elmGlyph.getAttribute(edgeAttributeName);
        if (Validator.isStringValid(edgeText)) {
            Edge edge = Edge.valueOf(edgeText);
            return edge;
        }
        return null;
    }
}

