/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.xml.DbTableGlyphXmlCtrl;
import com.harrand.dbwrench.xml.FkGlyphXmlCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.IGlyphStore;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import com.harrand.sketch.xml.DiagramProps;
import com.harrand.sketch.xml.NoteXmlCtrl;
import com.harrand.sketch.xml.RenderConfigXmlCtrl;
import com.harrand.sketch.xml.ZoneXmlCtrl;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiagramXmlCtrl
implements IXmlCtrl {
    private RenderConfigXmlCtrl rcXmlCtrl_ = new RenderConfigXmlCtrl();
    private DbTableGlyphXmlCtrl dbGlyphXmlCtrl_ = new DbTableGlyphXmlCtrl();
    private FkGlyphXmlCtrl fkGlyphXmlCtrl_ = new FkGlyphXmlCtrl();
    private NoteXmlCtrl noteXmlCtrl_ = new NoteXmlCtrl();
    private ZoneXmlCtrl zoneXmlCtrl_ = new ZoneXmlCtrl();
    private Version fromVersion_;
    public static final Version ADJUSTABLE_FONT_VER = new Version("1.3.2");
    public static final String DIAGRAM = "Dgm";

    public void setFromVersion(Version fromVersion) {
        this.fromVersion_ = fromVersion;
    }

    public Element asXmlElement(Document doc, Diagram diagram) {
        Element elmDiagram = doc.createElement(DIAGRAM);
        elmDiagram.setAttribute("nm", diagram.getName());
        Element elmRc = this.rcXmlCtrl_.asXmlElement(doc, diagram.getRenderConfig());
        elmDiagram.appendChild(elmRc);
        elmDiagram.appendChild(diagram.getDiagramProps().asXmlElement(doc));
        for (Glyph obj : diagram.getOnlyGlyphs()) {
            if (!(obj instanceof DbTableGlyph)) continue;
            DbTableGlyph glyph = (DbTableGlyph)obj;
            elmDiagram.appendChild(this.dbGlyphXmlCtrl_.asXmlElement(doc, glyph));
        }
        Iterator it = diagram.getLinksList().iterator();
        while (it.hasNext()) {
            Glyph obj;
            obj = it.next();
            if (!(obj instanceof ForeignKeyGlyph)) continue;
            ForeignKeyGlyph fkGlyph = (ForeignKeyGlyph)obj;
            elmDiagram.appendChild(this.fkGlyphXmlCtrl_.asXmlElement(doc, fkGlyph));
        }
        elmDiagram.appendChild(this.noteXmlCtrl_.asXmlElement(doc, diagram.getNotes()));
        elmDiagram.appendChild(this.zoneXmlCtrl_.asXmlElement(doc, diagram.getZones()));
        return elmDiagram;
    }

    public Diagram fromXml(Element element, IGlyphStore glyphStore) {
        Diagram newDiagram = null;
        String name = element.getAttribute("nm");
        RenderConfig rc = null;
        ArrayList glyphs = new ArrayList();
        List storedLinks = null;
        if (glyphStore != null) {
            rc = glyphStore.getRenderConfig(element);
            newDiagram = new Diagram(name, rc);
            newDiagram.setDiagramProps(this.getPropsFromXml(element));
            List storedGlyphs = glyphStore.getStoredGlyphs(element, newDiagram);
            glyphs.addAll(storedGlyphs);
            newDiagram.initAddGlyphs(storedGlyphs);
            storedLinks = glyphStore.getStoredLinks(element, newDiagram);
        } else {
            LogUtil.logErr("DiagramXmlCtrl.glyphStore is NULL");
        }
        this.addZoneObjs(element, newDiagram);
        this.addNoteObjs(element, newDiagram);
        try {
            if (storedLinks != null) {
                newDiagram.initLinks(storedLinks);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.logErr("DiagramXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newDiagram;
    }

    private void addZoneObjs(Element elmDiagram, Diagram newDiagram) {
        Element elmZones = XmlHelper.getFirstElementByTagName(elmDiagram, "Zones");
        if (elmZones != null) {
            List<Zone> zones = ZoneXmlCtrl.fromXml(elmZones);
            for (Zone zone : zones) {
                newDiagram.add(zone);
            }
        }
    }

    private void addNoteObjs(Element elmDiagram, Diagram newDiagram) {
        Element elmNotes = XmlHelper.getFirstElementByTagName(elmDiagram, "Notes");
        if (elmNotes != null) {
            List<Note> notes = NoteXmlCtrl.fromXml(elmNotes);
            for (Note note : notes) {
                newDiagram.add(note);
            }
        }
    }

    private DiagramProps getPropsFromXml(Element elmDiagram) {
        DiagramProps props = new DiagramProps();
        Element elmProps = XmlHelper.getFirstElementByTagName(elmDiagram, "DiaProps");
        props.fromXml(elmProps);
        return props;
    }
}

