/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.coreclasses.display.BasicColorable;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DbTableGlyphXmlCtrl
implements IXmlCtrl {
    public static final String DB_TBL_GLYPH = "TbGl";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String TBL = "tbl";
    public static final String SCHEMA = "sch";

    public Element asXmlElement(Document doc, DbTableGlyph glyph) {
        Element elmGlyph = doc.createElement(DB_TBL_GLYPH);
        elmGlyph.setAttribute(TBL, glyph.getTableName());
        elmGlyph.setAttribute(SCHEMA, glyph.getTable().getSchema().getName());
        XmlHelper.setAttr(elmGlyph, X, (int)glyph.getStart().getX());
        XmlHelper.setAttr(elmGlyph, Y, (int)glyph.getStart().getY());
        Color bkColor = glyph.getColor("MainBox");
        elmGlyph.setAttribute("bkCl", Integer.toHexString(bkColor.getRGB()));
        return elmGlyph;
    }

    public static DbTableGlyph fromXml(Element element, Database db, Diagram diagram) {
        String tblName = element.getAttribute(TBL);
        String schemaNm = element.getAttribute(SCHEMA);
        Schema schema = db.getSchema(schemaNm);
        Table table = schema.getTable(tblName);
        int x = XmlHelper.getAttrInt(element, X);
        int y = XmlHelper.getAttrInt(element, Y);
        Point start = new Point(x, y);
        Color bkColor = BasicColorable.fromXmlHexString(element, "bkCl");
        DbTableGlyph newGlyph = null;
        try {
            newGlyph = new DbTableGlyph(start, table, diagram);
            newGlyph.setColor("MainBox", bkColor);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.logErr("DbTableGlyphXmlCtrl.fromXml.error: " + e.getMessage());
        }
        return newGlyph;
    }
}

