/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.xml;

import com.harrand.dbwrench.object.CustomType;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CustomTypeXmlCtrl {
    public static final String CUSTOM_TYPES = "CustomTypes";
    public static final String CUSTOM_TYPE = CustomType.getClassName();

    public Element asXmlElement(Document doc, List<CustomType> customTypes) {
        Element elmTypes = doc.createElement(CUSTOM_TYPES);
        for (CustomType type : customTypes) {
            Element elmType = XmlHelper.createElementSimple(doc, CUSTOM_TYPE, type.getNotes());
            elmType.setAttribute("nm", type.getName());
            elmType.setAttribute("id", type.getName());
            XmlHelper.setAttr(elmType, "id", type.getId());
            elmTypes.appendChild(elmType);
        }
        return elmTypes;
    }

    public static List<CustomType> fromXml(Element elmTypes) {
        ArrayList<CustomType> customTypes = new ArrayList<CustomType>();
        NodeList elms = elmTypes.getElementsByTagName(CUSTOM_TYPE);
        for (int i = 0; i < elms.getLength(); ++i) {
            Element elm = (Element)elms.item(i);
            String nm = elm.getAttribute("nm");
            int id = XmlHelper.getAttrInt(elm, "id");
            String notes = XmlHelper.getElementValue(elm);
            CustomType type = new CustomType(id, nm, notes);
            customTypes.add(type);
        }
        return customTypes;
    }
}

